@extends('layouts.master')

@section('content')
    <style>
        table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        table,
        th,
        thead,
        td {
            border: 1px solid black;
            padding: .5rem;
        }
        th,
        td {
            text-align: left;
            vertical-align: top;
        }

        .table-headline {
            background-color: #c3c3c4;
            text-align: left;
            font-weight: bold;
            padding: .5rem;
            color: black;
        }


        .image-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1rem; /* equal to Bootstrap mb-3 */
        }

        .logo-container {
            width: 80%;
        }

        .photo-container {
            width: 20%;
            text-align: right;
        }

        /* Optional image sizing */
        .logo-img {
            max-width: 100%;
            height: auto;
        }

        .student-img {
            max-width: 100%;
            height: auto;
        }

        .top-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .top-info > div:first-child,
        .top-info > div:last-child {
            width: 300px; /* set equal fixed width */
        }

        .top-info > div:nth-child(2) {
            flex: 1; /* take remaining space */
            text-align: center;
        }

        .info-box {
            padding: 0.5rem 1rem;
            border: 1px solid #6c757d;
            margin: 0;
        }

        .group-title {
            font-weight: bold;
            color: black;
            margin: 0;
        }

        .signature-container {
            display: flex;
            justify-content: space-between;
        }

        .signature-block {
            text-align: center;
            
        }
        .signature-line {
            border-bottom: 1px solid #000;
            width: 200px;
            height: 2rem; /* space for actual signature */
        }
        .signature-block p{
            margin-bottom: 0px;
        }

        .footer {
            text-align: center;
           margin-bottom: 10px;
        }




    </style>

    @php
    use Carbon\Carbon;
    $birthdate = $applicant->dob; // Example birthdate
    try {
        // Parse the birthdate
        $birthdate = Carbon::createFromFormat('Y-m-d', $birthdate);
        $now = Carbon::now();
        $age = $birthdate->diff($now)->format('Age: %y Years, %m Months, %d Days');
    } catch (\Exception $e) {
        // Handle the error if the date parsing fails
        $age = 'Invalid date format';
    }

@endphp


    <div class="card std__form">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">View HSC Applicant Info</h6>
            <div class="m-0 float-right">
                <a class="btn btn-sm btn-light-blue" href="{{ route('hsc-admission.index') }}">View All</a>
                {{-- <a class="btn btn-sm btn-light-blue" href="{{ route('hsc-admission.print',$applicant->id) }}">Print</a> --}}

                <a class="btn btn-secondary btn__export mr-1" href="#" data-toggle="tooltip" onclick="printMarkDiv()"
                        title="Print">
                        <i class="fas fa-print"></i>
                    </a>

            </div>
        </div>
        <div class="card-body m-3 print-container">

            <!-- Image Header -->
            <div class="image-header">
                <div class="logo-container">
                    <img src="{{ asset('/default/nobabgonj.png') }}" class="logo-img" alt="College Logo">
                </div>
                <div class="photo-container">
                    <img src="{{  asset($applicant->profile_image) }}" class="student-img" alt="Applicant Photo">
                </div>
            </div>

            <!-- Top Info -->
            <div class="top-info">
                <div>
                    <p class="info-box"><strong>College Code:</strong> 1756</p>
                </div>
                <div>
                    <h5 class="group-title">Group Of {{ ucfirst($applicant->hscgruop) ?? 'N/A' }}</h5>
                </div>
                <div>
                    <p class="info-box"><strong>Application Date:</strong> {{ view_date_format($applicant->created_at) }} </p>
                </div>
            </div>


            <table class="">
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Applicant Information</th>
                    </tr>
                    <tr>
                        <th>Student's Name (English)</th>
                        <td>{{ $applicant->first_name ?? 'N/A' }}</td>
                        <th>Class Roll</th>
                        <td> {{ $applicant->class_roll ?? 'N/A' }} </td>
                    </tr>
                    <tr>
                        <th>SSC Roll</th>
                        <td>{{ $applicant->ssc_roll_num ?? 'N/Ahsc-applicant.png' }}</td>
                        <th>Merit Position</th>
                        <td>{{ $applicant->merit_position ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Student's Mobile Number</th>
                        <td>{{ $applicant->applicant_mobile ?? 'N/A' }}</td>
                        <th>Blood Group</th>
                        <td>{{ $applicant->blood_group ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Birth Certificate/Nid Card</th>
                        <td>{{ $applicant->nid ?? 'N/A' }}</td>
                        <th>Date of Birth</th>
                        <td>{{ $applicant->dob ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Marital Status</th>
                        <td>{{ $applicant->marital_status ?? 'N/A' }}</td>
                        <th>Age</th>
                        <td>{{ $age ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Gender</th>
                        <td>{{ $applicant->gender ?? 'N/A' }}</td>
                        <th>Religion</th>
                        <td>{{ $applicant->religion ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td>{{ $applicant->email ?? 'N/A' }}</td>
                        <th>Nationality</th>
                        <td>{{ $applicant->nationality ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>

             <!-- Parent/Guardian Information -->
            <table >
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Parent/Guardian Information</th>
                    </tr>
                    <tr>
                        <th>Father's Name (English)</th>
                        <td>{{ $applicant->father_name ?? 'N/A' }}</td>
                        <th>Father's NID Number</th>
                        <td>{{ $applicant->father_nid ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Father's Mobile Number</th>
                        <td>{{ $applicant->father_mobile ?? 'N/A' }}</td>
                        <th>Father's Date of Birth</th>
                        <td>{{ $applicant->father_dob ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Father's Monthly Income</th>
                        <td>{{ $applicant->father_income ?? 'N/A' }}</td>
                        <th>Father's Occupation</th>
                        <td>{{ $applicant->father_occupation ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Mother's Name (English)</th>
                        <td>{{ $applicant->mother_name ?? 'N/A' }}</td>
                        <th>Mother's NID Number</th>
                        <td>{{ $applicant->mother_nid ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Mother's Mobile Number</th>
                        <td>{{ $applicant->mother_mobile ?? 'N/A' }}</td>
                        <th>Mother's Date of Birth</th>
                        <td>{{ $applicant->mother_dob ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Mother's Monthly Income</th>
                        <td>{{ $applicant->mother_income ?? 'N/A' }}</td>
                        <th>Mother's Occupation</th>
                        <td>{{ $applicant->mother_occupation ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Guardian's Name (English)</th>
                        <td>{{ $applicant->guardian_name ?? 'N/A' }}</td>
                        <th>Guardian's Mobile</th>
                        <td>{{ $applicant->guardian_mobile ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Guardian's Address</th>
                        <td>{{ $applicant->guardian_address ?? 'N/A' }}</td>
                        <th>Guardian's Relation</th>
                        <td>{{ $applicant->guardianRelation?->name ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>
            <!-- Present Address -->
            <table>
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Present Address</th>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td>{{ $applicant->present_address ?? 'N/A' }}</td>
                        <th>Union/Word No</th>
                        <td>{{ $applicant->presentUnion?->name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Upazila/Police Station</th>
                        <td>{{ $applicant->presentUpazila?->name ?? 'N/A' }} </td>
                        <th>District</th>
                        <td>  {{ $applicant->presentDistrict?->name ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Permanent Address -->
            <table>
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Permanent Address</th>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td>{{ $applicant->permanent_address ?? 'N/A' }}</td>
                        <th>Union/Word No</th>
                        <td>{{ $applicant->permanentUnion?->name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Upazila/Police Station</th>
                        <td>{{ $applicant->permanentUpazila?->name ?? 'N/A' }} </td>
                        <th>District</th>
                        <td>{{ $applicant->permanentDistrict?->name ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Special Quota & Community -->
            <table >
                <tbody>
                        <tr class="table-headline">
                        <th colspan="4">Special Quota and Community</th>
                    </tr>
                    <tr>
                        <th>Special Quota</th>
                        <td>{{ $applicant->special_quata ?? 'No' }}</td>
                        <th>Community</th>
                        <td>{{ $applicant->community ?? 'No' }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Academic Information -->
            <table>
                <tbody>
                        <tr class="table-headline">
                        <th colspan="8">Academic Information</th>
                    </tr>
                    <tr>
                        <th>SSC Board</th>
                        <td>{{ $applicant->board_select ?? 'N/A' }}</td>
                        <th>Passing Year</th>
                        <td>{{ $applicant->passing_year ?? 'N/A' }}</td>
                        <th>Institute</th>
                        <td colspan="3">{{ $applicant->institute_name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>SSC Roll</th>
                        <td>{{ $applicant->ssc_roll_num ?? 'N/A' }}</td>
                        <th>SSC Registration</th>
                        <td>{{ $applicant->ssc_reg_num ?? 'N/A' }}</td>
                        <th>SSC Session</th>
                        <td>{{ $applicant->ssc_session ?? 'N/A' }}</td>
                        <th>SSC GPA</th>
                        <td>{{ $applicant->ssc_gpa ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>

            <!-- Subject Choice Information -->
            <table>
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Subject Choice Information</th>
                    </tr>
                    <tr>
                        <th>Main Subjects</th>
                        <td>{{ collect([$applicant->main_subject1, $applicant->main_subject2, $applicant->main_subject3])->filter()->map(fn($id) => subject_name($id))->implode(', ') }}</td>
                        <th>4th Subjects</th>
                        <td>{{ subject_name($applicant->optional_subject) }} </td>
                    </tr>
                    <tr>
                        <th>Elective Subjects</th>
                        <td colspan="3">{{ collect([$applicant->elective_subject1, $applicant->elective_subject2, $applicant->elective_subject3])->filter()->map(fn($id) => subject_name($id))->implode(', ') }}</td> 
                    </tr>
                </tbody>
            </table>

            <!-- Payment Information -->
            <table>
                <tbody>
                    <tr class="table-headline">
                        <th colspan="4">Payment Information (In Total)</th>
                    </tr>
                    <tr>
                        <th>Payment Method</th>
                        <td>{{ $applicant->group_payment ?? 'N/A' }}</td>
                        <th>From Account</th>
                        <td>{{ $applicant->payment_from_account ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Payment Amount</th>
                        <td>{{ $applicant->payment_amount ?? 'N/A' }}</td>
                        <th>TnxID (Transaction ID)</th>
                        <td>{{ $applicant->payment_tnxid ?? 'N/A' }}</td>
                    </tr>
                </tbody>
            </table>
            <!-- Signatures -->
            <div class="signature-container">
                <div class="signature-block">
                    <div class="signature-line"></div>
                    <span>Applicant's Signature</span>
                </div>
                <div class="signature-block">
                    <div class="signature-line"></div>
                    <span>Principal's Signature</span>
                </div>
            </div>


            <div class="footer mb-5">
                <p>Education Management System - Design & Develop by JBD IT</p>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>


    function printMarkDiv() {
        const divsToPrint = document.getElementsByClassName("print-container");
        // const certificateBgUrl = window.certificateBgUrl || "/default/certificate-back.png";
        const newWin = window.open("", "_blank");

        let htmlToPrint = `
        <html>
        <head>
            <title>HSC Applicant Admission Form</title>
            <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,700&display=swap">
            <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Dancing+Script:wght@600&display=swap">
            <style>
                @page {
                    size: A4;
                    margin: 0;
                }
                .hide-btn{
                    visibility: hidden;
                }
                @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

                body {
                    font-family: "Roboto", sans-serif;
                    font-style: normal;
                }
                table {
                    width: 100%;
                    margin-bottom: 8px;
                    border-collapse: collapse;
                }

                table,
                th,
                thead,
                td {
                    border: 1px solid black;
                    font-size:15px;
                    padding: 1px;
                }
                table th{
                    font-weight: 100;
                    border-top: 1px solid black;
                }
                th,
                td {
                    text-align: left;
                    vertical-align: top;
                }

                .table-headline {
                    background-color: #c3c3c4;
                    text-align: left;
                    font-weight: bold;
                    padding: .5rem;
                    color: black;
                }

                .image-header {
                    display: flex;
                    justify-content: space-between;
                    margin-bottom: 1rem; /* equal to Bootstrap mb-3 */
                }

                .logo-container {
                    width: 80%;
                }

                .photo-container {
                    width: 20%;
                    text-align: right;
                }

                /* Optional image sizing */
                .logo-img {
                    max-width: 100%;
                    height: auto;
                }

                .student-img {
                    max-width: 100px;
                    height: auto;
                }
                
                .top-info {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 8px;
                }

                .top-info > div:first-child,
                .top-info > div:last-child {
                    width: 300px; /* set equal fixed width */
                }

                .top-info > div:nth-child(2) {
                    flex: 1; /* take remaining space */
                    text-align: center;
                }

                .info-box {
                    padding: 0.5rem 8px;
                    border: 1px solid #6c757d;
                    margin: 0;
                }

                .group-title {
                    font-weight: bold;
                    color: black;
                    margin: 0;
                }
                    
                .signature-container {
                    display: flex;
                    justify-content: space-between;
                }

                .signature-block {
                    text-align: center;
                    
                }
                .signature-line {
                    border-bottom: 1px solid #000;
                    width: 200px;
                    height: 2rem; /* space for actual signature */
                }
                .signature-block p{
                    margin-bottom: 0px;
                }

                .footer {
                    text-align: center;
                    margin-bottom: 10px;
                }
                @media print {
                    body {
                        -webkit-print-color-adjust: exact;
                        print-color-adjust: exact;
                        padding:10px;
                    }
                }
            </style>
        </head>
        <body>
        `;

        for (let i = 0; i < divsToPrint.length; i++) {
            htmlToPrint += `
            <div class="print-page">
                ${divsToPrint[i].innerHTML}
            </div>
            `;
        }

        htmlToPrint += `
        </body>
        </html>
        `;

        newWin.document.open();
        newWin.document.write(htmlToPrint);
        newWin.document.close();

        newWin.onload = function () {
            newWin.focus();
            newWin.print();
            newWin.close();
        };
    }




    </script>
@endsection
