@extends('layouts.master')
@section('styles')
<link rel="stylesheet" href="https://prismjs.com/themes/prism.css">
<script src="https://prismjs.com/prism.js"></script>
<script src={{ asset('assets/vendor/multi-file/js/docs.js') }}></script>
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>
@endsection
@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Edit Product</h6>
            <div class="m-0 float-right">
                @can('inventory.product.view')
                <a href="{{ route('product.index') }}" class="btn btn-sm btn-light-blue">View All</a>
                @endcan
            </div>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('product.update',$product->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input type="text" value="{{ $product->name }}" class="form-control" id="name" name="name" required>
                            @error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="current_stock">Current Stock</label>
                            <input type="number" min="0" value="{{ $product->current_stock }}" class="form-control" id="current_stock" name="current_stock">
                            @error('current_stock')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="purchase_price">Purchase Price</label>
                            <input type="number" min="0" value="{{ $product->purchase_price }}" class="form-control" id="purchase_price" name="purchase_price">
                            @error('purchase_price')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="sale_price">Sale Price</label>
                            <input type="number" min="0" value="{{ $product->sale_price }}" class="form-control" id="sale_price" name="sale_price">
                            @error('sale_price')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    {{--<div class="col-md-8">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description">{!! $product->description !!}</textarea>
                            @error('description')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Upload Image <span class="text-danger">You can select multiple Image</span></label>
                            <input name="attachment[]" type="file" multiple="multiple" class="multi" maxlength="10" data-maxfile="1024" accept="gif|jpeg|jpg|png"/>
                            @error('attachment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>--}}

                </div>

                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-submit">Submit</button>
                </div>

            </form>
        </div>
    </div>
@endsection
@section('scripts')
<script src={{ asset('assets/vendor/multi-file/js/jquery.form.js') }}></script>
<script src={{ asset('assets/vendor/multi-file/js/jquery.MetaData.js') }}></script>
<script src={{ asset('assets/vendor/multi-file/js/jquery.MultiFile.min.js') }}></script>
<script>
    $(document).ready(function () {
        $('#description').summernote({
            height: 200
        });
        document.getElementById("quantity").addEventListener("keyup", function() {
          this.value = this.value.replace(/[^0-9]/g,"");
        });

        document.getElementById("price").addEventListener("keyup", function() {
          this.value = this.value.replace(/[^0-9]/g,"");
        });
    })
</script>
@endsection
