@extends('layouts.master')
@section('content')
    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
            <h6 class="m-0 table__top__txt">Product List</h6>
            <div class="m-0 float-right">
                @can('inventory.product.create')
                    <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                            data-toggle="modal" data-target="#dataStoreModal">Add New
                    </button>
                @endcan
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table" id="dataTable">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Purchase Price</th>
                            <th>Sale Price</th>
                            <th>Current Stock</th>
                            <th>Accounting Head</th>
                            <th class="action__col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php $sn = 0; @endphp
                        @foreach($products as $product)
                            <tr>
                                <td>{{ ++$sn }}</td>
                                <td>{{ Str::limit($product->name,80) }}</td>
                                <td>{{ $product->purchase_price }}</td>
                                <td>{{ $product->sale_price }}</td>
                                <td>{{ $product->current_stock }}</td>
                                <td>{{ $product->accountingHead?->name ?? 'N/A' }}</td>
                                <td class="d-flex justify-content-start">
                                    @can('inventory.product.edit')
                                        <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                data-toggle="modal"
                                                data-target="#dataEditModal" data-name="{{ $product->name }}"
                                                data-purchase-price="{{ $product->purchase_price }}"
                                                data-sale-price="{{ $product->sale_price }}"
                                                data-current-stock="{{ $product->current_stock }}"
                                                data-id="{{ $product->id }}"
                                                data-accounting-head-id="{{ $product->accounting_head_id }}"><i
                                                class="fas fa-edit"></i>
                                        </button>
                                    @endcan

                                    @can('inventory.product.delete')
                                        <form action="{{ route('product.destroy', $product->id) }}" method="POST"
                                              style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-soft-danger" title="Delete"
                                                    onclick="return confirm('Are you sure?')"><i
                                                    class="fas fa-trash"></i></button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('product.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Product </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Product Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" maxlength="250"
                                           required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="current_stock">Current Stock</label>
                                    <input type="number" min="0" class="form-control" id="current_stock"
                                           name="current_stock">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="purchase_price">Purchase Price</label>
                                    <input type="number" min="0" class="form-control" id="purchase_price"
                                           name="purchase_price">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sale_price">Sale Price</label>
                                    <input type="number" min="0" class="form-control" id="sale_price" name="sale_price">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="accounting_head_id">Accounting Head</label>
                                    <select class="form-control" id="accounting_head_id" name="accounting_head_id">
                                        <option value="">Select Accounting Head</option>
                                        @foreach($accountingHeads as $accountingHead)
                                            <option
                                                value="{{ $accountingHead->id }}">{{ $accountingHead->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->


    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('product.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Product </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Product Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" maxlength="250"
                                           required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="current_stock">Current Stock</label>
                                    <input type="number" min="0" class="form-control" id="current_stock"
                                           name="current_stock">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="purchase_price">Purchase Price</label>
                                    <input type="number" min="0" class="form-control" id="purchase_price"
                                           name="purchase_price">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sale_price">Sale Price</label>
                                    <input type="number" min="0" class="form-control" id="sale_price" name="sale_price">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="accounting_head_id">Accounting Head</label>
                                    <select class="form-control" id="accounting_head_id" name="accounting_head_id">
                                        <option value="">Select Accounting Head</option>
                                        @foreach($accountingHeads as $accountingHead)
                                            <option
                                                value="{{ $accountingHead->id }}">{{ $accountingHead->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary submitBtn">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

@endsection
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var purchasePrice = button.data('purchase-price')
            var salePrice = button.data('sale-price')
            var stock = button.data('current-stock')
            var id = button.data('id')
            var accountingHeadId = button.data('accounting-head-id')
            var modal = $(this)
            modal.find('#name').val(name)
            modal.find('#purchase_price').val(purchasePrice)
            modal.find('#sale_price').val(salePrice)
            modal.find('#current_stock').val(stock)
            modal.find('#id').val(id)
            modal.find('#accounting_head_id').val(accountingHeadId)
        })
    </script>
@endsection
