@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Show Product</h6>
            <div class="m-0 float-right">
                @can('inventory.product.view')
                <a href="{{ route('product.index') }}" class="btn btn-sm btn-light-blue">View All</a>
                @endcan
            </div>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('product.update',$product->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Name <span class="text-danger">*</span></label>
                            <input readonly type="text" value="{{ $product->name }}" class="form-control" id="name" name="name" required>
                            @error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="current_stock">Current Stock</label>
                            <input readonly type="number" min="0" value="{{ $product->current_stock }}" class="form-control" id="current_stock" name="current_stock">
                            @error('current_stock')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="purchase_price">Purchase Price</label>
                            <input readonly type="number" min="0" value="{{ $product->purchase_price }}" class="form-control" id="purchase_price" name="purchase_price">
                            @error('purchase_price')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="sale_price">Sale Price</label>
                            <input readonly type="number" min="0" value="{{ $product->sale_price }}" class="form-control" id="sale_price" name="sale_price">
                            @error('sale_price')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="code">Code</label>
                            <input readonly type="text" min="0" value="{{ $product->code }}" class="form-control" id="code" name="code">
                            @error('code')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>



                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea readonly class="form-control" id="description" name="description">{!! $product->description !!}</textarea>
                            @error('description')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="pb-2" for="attachment">Uploaded Image</div>
                            @php
                            $attachments = json_decode($product->image, true);
                            @endphp
                            @if(is_array($attachments))
                            @foreach($attachments as $filePath)
                            <img width="80px" src="{{asset($filePath)}}">
                            @endforeach
                            @endif
                        </div>
                    </div>

                </div>


            </form>
        </div>
    </div>
@endsection
@section('scripts')
<script>
    $(document).ready(function () {
        $('#description').summernote({
            height: 200
        });
    })
</script>
@endsection
