@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom mb-3">
        <h6 class="m-0 table__top__txt">Sales List</h6>
        <div class="m-0 float-right">
            @can('inventory.sales.create')
            <a class="btn btn-sm btn-light-blue" href="{{route('sales.create')}}">Add New</a>
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Invoice Number</th>
                            <th>Student ID</th>
                            <th>Total Amount</th>
                            <th>Total Discount</th>
                            <th>Grand Total</th>
                            <th>Transaction Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sales as $sale)
                        <tr>
                            <td>{{ $sale->invoice_number }}</td>
                            <td>{{ $sale->student_id }}</td>
                            <td>{{ $sale->total_amount }}</td>
                            <td>{{ $sale->total_discount }}</td>
                            <td>{{ $sale->grand_total }}</td>
                            <td>{{ $sale->transaction_date ?  Carbon\Carbon::parse($sale->transaction_date)->format('d-m-Y') : 'N/A' }}</td>
                            <td class="d-flex justify-content-start">
                                <a class="btn btn-soft-secondary btn__export" href="{{ route('sales.print',$sale->id)}}" title="Print">
                                    <i class="fas fa-print"></i>
                                </a>

                                @can('inventory.sales.show')
                                <a href="{{ route('sales.show', $sale->id) }}" class="btn btn-soft-success btn-sm mx-1" data-toggle="tooltip" title="View" target="_blank"><i class="fas fa-eye"></i></a>
                                @endcan
                                @can('inventory.sales.edit')
                                <a href="{{ route('sales.edit', $sale->id) }}" class="btn btn-sm btn-soft-info mx-1" title="Edit"><i class="fas fa-edit"></i></a>
                                @endcan
                                @can('inventory.sales.delete')
                                <form action="{{ route('sales.destroy', $sale->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-soft-danger" title="Delete" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i></button>
                                </form>
                                @endcan
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
