@extends('layouts.master')
@section('content')
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            color: #1d1d1d;
            width: 100%;
        }
        .main{
            padding-top: 20px;
            padding-left: 20px;
            padding-right: 20px;
        }
        .header-container {
            text-align: center;
            margin-bottom: 10px;
        }
        .header-container img {
            height: 60px; /* Adjust logo size */
        }
        .header-container h2 {
            margin: 5px 0;
            font-size: 18px; /* Adjust font size for A5 */
        }
        .header-container p {
            margin: 3px 0;
            font-size: 14px;
        }
        .top-info p{
            margin-bottom: 5px;
        }
        /*.body table thead {*/
        /*    background: #e1e1e1;*/
        /*}*/
        .body table thead th:first-child {
            border-radius: 0 !important;
        }
        .body table thead th:nth-child(3),
        .body table tbody td:nth-child(3) {
            text-align: center;
        }
        .body table thead th:nth-child(4),
        .body table tbody td:nth-child(4) {
            text-align: right;
        }
        .body table thead th:last-child {
            border-radius: 0 !important;
            text-align: right;
        }
        .body table thead tr th {
            border: none;
            padding: 10px 10px 8px;
            color: black;
            line-height: 1;
        }
        .body table {
            margin-bottom: 8px;
        }
        .body table tbody tr td {
            border-top: none;
            padding: 8px;
            color: black;
            border-bottom: 1px solid #e9e9e9;
        }
        .head {
            padding: 15px;
            border: 1px solid #ededed;
            display: flex;
            margin-bottom: 8px;
            background-color: #f5f5f5b8;
        }
        .head .left {
            width: 50%;
            text-align: left;
            color: black;
        }
        .head .right p,
        .head .left p {
            margin-bottom: 7px;
            margin-top: 0;
            font-size: 15px;
        }
        .head .right {
            width: 50%;
            text-align: right;
            color: black;
        }
        .head .right span {
            font-weight: 700;
            font-size: 28px;
            color: green;
        }
        .foot {
            display: flex;
        }
        .foot .prepared_by {
            width: 20%;
            text-align: center;
            position: absolute;
            bottom: 10px;
            left: 10px;
        }
        .foot .prepared_by .name {
            color: black;
        }
        .foot .content {
            width: 100%;
            text-align: right;
            color: black;
            padding-right: 10px;
        }
        .foot .content p {
            margin-bottom: 6px;
            font-size: 14px;
            color: #4a4a4a;
        }
        .invoice_footer .title_message {
            text-align: center;
            margin-top: 0;
            font-family: cursive;
            color: black;
            margin-bottom: 7px;
            font-size: 13px;
        }
        .invoice_footer .powerby {
            color: #747474;
            font-size: 12px;
            font-weight: 300;
            text-align: center;
            background: #eee;
            margin-top: 12px;
            padding: 5px;
            line-height: 1;
        }
        .invoice_footer .powerby span {
            color: black;
            letter-spacing: .5px;
            font-weight: bold;
        }
        @media print {
            @page {
                size: A5 landscape; /* Set page size to A5 in portrait orientation */
            }
            body {
                font-size: 12px; /* Reduce font size for smaller paper */
            }
            .no-print {
                display: none;
            }
        }

    </style>


    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <a href="{{ route('sales.index') }}" class="btn btn-success btn-sm">Back</a>
        <button class="btn btn-success btn-sm" onclick="printData()">Print</button>
    </div>

    @php
        $logo = get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('uploads/images/logo.png') ?? '';
        $instituteName = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
        $branch_address = get_branch_info()->address ? get_branch_info()->address : '';
        $branch_contact_info = get_branch_info()->contact_info ? get_branch_info()->contact_info : '';
    @endphp

    <div id="printData" class="main invoice_content">
        <div class="header-container">
            <img src="{{ $logo }}" alt="Institute Logo">
            <h2>{{ $instituteName }}</h2>
            <p>{{ $branch_address }}</p>
            <p>{{ $branch_contact_info }}</p>
            <p><strong>Sales Invoice</strong></p>
        </div>

        <div class="head">
            <div class="left">
                <p><b>Name: {{ $sale->student->name ?? '' }}</b>
                </p>
                <p>Student ID: {{ $sale->student_id ?? '' }}</p>
            </div>
            <div class="right">
                <p>Invoice: {{ $sale->invoice_number ?? '' }} </p>
                <p>Date: {{ $sale->transaction_date ? Carbon\Carbon::parse($sale->transaction_date)->format('d-m-Y') : ''  }}</p>
                <span>PAID</span>
            </div>
        </div>

    <div class="position-relative">
        <div class="body">
            <table width="100%">
                <thead>
                    <tr>
                        <th class="text-center">SL</th>
                        <th align="left">Product Name</th>
                        <th align="center">Quantity</th>
                        <th align="center">Price</th>
                        <th class="text-center">Discount</th>
                        <th class="text-center">Discount %</th>
                        <th align="right">Total</th>
                    </tr>
                </thead>
                <tbody border-bottom="5">
                    @foreach($sale->stockOut as $key=>$detail)
                        <tr>
                            <td class="text-center">{{ ++$key }}</td>
                            <td align="left">{{ $detail->product->name }}</td>
                            <td align="center">{{ $detail->quantity }}</td>
                            <td align="center">{{ $detail->price }}</td>
                            <td align="center">{{ $detail->discount_amount }}</td>
                            <td class="text-center">{{ $detail->discount_percentage }}</td>
                            <td align="right">{{ $detail->final_amount }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="foot">
            <div class="prepared_by">
                <div class="name">{{ auth()->user()->name }}
                    <hr style="margin: 2px;width: 162px;margin: 0 auto;">
                    <span style="color: #6c757d;">Signature</span>
                </div>
            </div>
            <div class="content">
                <p><strong>Total Amount:</strong> {{ $sale->total_amount ?? '0.00' }} Tk</p>
                <p><strong>Total Discount:</strong> {{ $sale->total_discount ?? '0.00' }} Tk</p>
                <p><strong>Grand Total:</strong> {{ $sale->grand_total ?? '0.00' }} Tk </p>
            </div>
        </div>

    </div>



                <div class="invoice_footer">
                    <div class="powerby">
                        <div class="title_message">Thank you for your payment</div>
                        Powered By <span>EduEasy</span>
                    </div>
                </div>
    </div>
@endsection
@section('scripts')
    <script>

    function printData() {

    let content = document.getElementById('printData').innerHTML;
    let printWindow = window.open('', '', 'height=900,width=1100');

    // Write the HTML content for the print window
    printWindow.document.write(`
        <html>
            <head>
                <title>Print</title>
                <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            color: #1d1d1d;
            width: 100%;
        }
        .main{
            padding-top: 20px;
            padding-left: 20px;
            padding-right: 20px;
        }
        .header-container {
            text-align: center;
            margin-bottom: 10px;
        }
        .header-container img {
            height: 60px; /* Adjust logo size */
        }
        .header-container h2 {
            margin: 5px 0;
            font-size: 18px; /* Adjust font size for A5 */
        }
        .header-container p {
            margin: 3px 0;
            font-size: 14px;
        }
        .top-info p{
            margin-bottom: 5px;
        }
        .body table thead {
            background: #e1e1e1;
        }
        .body table thead th:first-child {
            border-radius: 0 !important;
        }
        .body table thead th:nth-child(3),
        .body table tbody td:nth-child(3) {
            text-align: center;
        }
        .body table thead th:nth-child(4),
        .body table tbody td:nth-child(4) {
            text-align: right;
        }
        .body table thead th:last-child {
            border-radius: 0 !important;
            text-align: right;
        }
        .body table thead tr th {
            border: none;
            padding: 6px 10px;
            color: black;
            line-height: 1;
        }
        .body table {
            margin-bottom: 8px;
        }
        .body table tbody tr td {
            border-top: none;
            padding: 8px;
            color: black;
            border-bottom: 1px solid #e9e9e9;
        }
        .head {
            padding: 15px;
            border: 1px solid #ededed;
            display: flex;
            margin-bottom: 8px;
            background-color: #f5f5f5b8;
        }
        .head .left {
            width: 50%;
            text-align: left;
            color: black;
        }
        .head .right p,
        .head .left p {
            margin-bottom: 7px;
            margin-top: 0;
            font-size: 15px;
        }
        .head .right {
            width: 50%;
            text-align: right;
            color: black;
        }
        .head .right span {
            font-weight: 700;
            font-size: 28px;
            color: green;
        }
        .foot {
            display: flex;
        }
        .foot .prepared_by {
            width: 20%;
            text-align: center;
            position: absolute;
            bottom: 60px;
            left: 10px;
        }
        .foot .prepared_by .name {
            color: black;
        }
        .foot .content {
            width: 100%;
            text-align: right;
            color: black;
            padding-right: 10px;
        }
        .foot .content p {
            margin-bottom: 6px;
            font-size: 14px;
            color: #4a4a4a;
        }
        .invoice_footer .title_message {
            text-align: center;
            margin-top: 0;
            font-family: unset;
            color: black;
            margin-bottom: 7px;
            font-size: 13px;
        }
        .invoice_footer .powerby {
            color: #747474;
            font-size: 12px;
            font-weight: 300;
            text-align: center;
            background: #eee;
            margin-top: 12px;
            padding: 5px;
            line-height: 1;
        }
        .invoice_footer .powerby span {
            color: black;
            letter-spacing: .5px;
            font-weight: bold;
        }
        @media print {
            @page {
                size: A5 landscape;
                margin: 0; /* Remove default margins */
            }
            body, html {
                margin: 0;
                padding: 0;
                width: 100%;
                height: 100%;
            }
            .main, .invoice_content {
                padding: 0; /* Remove any padding */
                margin: 0; /* Remove any margins */
                width: 100%;
            }
        }
    </style>
            </head>
            <body>
                ${content}
            </body>
        </html>
    `);

    printWindow.document.close();

    printWindow.focus();

    setTimeout(() => {
                printWindow.print();
                printWindow.close();
    }, 500);
    // printWindow.print();

    // printWindow.close();
}

    </script>
@endsection

