@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Sale Details</h6>
            <div class="m-0 float-right">
                @can('inventory.sales.view')
                <a href="{{ route('sales.index') }}" class="btn btn-sm btn-primary">Sales List</a>
                @endcan
            </div>
        </div>
        <div class="">
            <div class="p-3">
                <p class="pb-1 m-0"><b>Transaction Date:</b> {{ $sale->transaction_date ?  Carbon\Carbon::parse($sale->transaction_date)->format('d-m-Y') : 'N/A' }}</p>
                <p class="pb-1 m-0"><b>Invoice Number:</b> {{ $sale->invoice_number }}</p>
                <p class="pb-1 m-0"><b>Student ID:</b> {{ $sale->student_id }}</p>
                <p class="pb-1 m-0"><b>Total Amount:</b> {{ $sale->total_amount }}</p>
                <p class="pb-1 m-0"><b>Total Discount:</b> {{ $sale->total_discount }}</p>
                <p class="pb-1 m-0"><b>Grand Total:</b> {{ $sale->grand_total }}</p>
            </div>
            <div class="table-responsive" >
                <table class="table table-strip">
                    <thead class="thead-light">
                        <tr>
                            <th>Product Name</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Discount Amount</th>
                            <th>Discount Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($sale->stockOut as $detail)
                        <tr>
                            <td>{{ $detail->product->name }}</td>
                            <td>{{ $detail->quantity }}</td>
                            <td>{{ $detail->price }}</td>
                            <td>{{ $detail->discount_amount }}</td>
                            <td>{{ $detail->discount_percentage }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

{{--


@extends('layouts.master')
@section('content')
<div class="container">
    <h1>Sale Details</h1>
    <p>Invoice Number: {{ $sale->invoice_number }}</p>
    <p>Student ID: {{ $sale->student_id }}</p>
    <p>Total Amount: {{ $sale->total_amount }}</p>
    <h3>Items</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Product Name</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Discount Amount</th>
                <th>Discount Percentage</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sale->stockOut as $detail)
            <tr>
                <td>{{ $detail->product->name }}</td>
                <td>{{ $detail->quantity }}</td>
                <td>{{ $detail->price }}</td>
                <td>{{ $detail->discount_amount }}</td>
                <td>{{ $detail->discount_percentage }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
@extends('layouts.app')
@section('content')
<div class="container">
    <h1>Sale Details</h1>
    <p>Invoice Number: {{ $sale->invoice_number }}</p>
    <p>Student ID: {{ $sale->student_id }}</p>
    <p>Total Amount: {{ $sale->total_amount }}</p>
    <h3>Items</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Product ID</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Discount Amount</th>
                <th>Discount Percentage</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sale->salesDetails as $detail)
            <tr>
                <td>{{ $detail->product_id }}</td>
                <td>{{ $detail->quantity }}</td>
                <td>{{ $detail->price }}</td>
                <td>{{ $detail->discount_amount }}</td>
                <td>{{ $detail->discount_percentage }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
--}}