@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Library Book Issue</h6>
        <div class="m-0 float-right">
        </div>
    </div>
    <div class="row">
        <div class="col-md-3">
            <div class="mx-3 mb-3 border rounded p-2">
                <div class="text-center pb-3">
                    @php
                        $profile = $member->user->profile_image_path ? $member->user->profile_image_path : 'uploads/student/graduated_student.png';
                    @endphp
                    <img src="{{asset($profile)}}" class="rounded-circle border p-1" alt="" height="70px" width="70px">
                </div>
                <div class="d-flex justify-content-between border-bottom mb-2">
                    <div class="name">Name</div>
                    <div class="value">{{ $member->user->name }}</div>
                </div>
                <div class="d-flex justify-content-between border-bottom mb-2">
                    <div class="name">Member ID</div>
                    <div class="value">{{ $member->member_ud_id }}</div>
                </div>
                <div class="d-flex justify-content-between border-bottom mb-2">
                    <div class="name">Member Type</div>
                    <div class="value text-capitalize">{{ $member->user->user_type }}</div>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <div class="name">Mobile</div>
                    <div class="value">{{ $member->user->phone_number }}</div>
                </div>
            </div>
            <div class="mx-3 mb-3 border rounded p-2">
                <div class="text-center pb-3">
                    <h4>Issue Book</h4>
                </div>
                <div class="form">
                    <form method="post" action="{{ route('bookissue.store') }}">
                        @csrf

                        <div class="form-group">
                            <label for="booklist_id">Book <span class="text-danger">*</span></label>
                            <select class="form-control select2 book" id="booklist_id" name="booklist_id" required>
                                <option value="">Select Book</option>
                                @foreach($books as $book)
                                <option value="{{ $book->id }}">{{ $book->title }}</option>
                                @endforeach
                            </select>
                            @error('booklist_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <input type="hidden" name="user_id" value="{{ $member->user_id }}">
                        <input type="hidden" name="bookmember_id" value="{{ $member->id }}">
                        <div class="form-group">
                            <label for="estimate_return_date">Return Date <span class="text-danger">*</span></label>
                            <input type="date" value="{{ old('estimate_return_date') }}" class="form-control" id="estimate_return_date" name="estimate_return_date" required>
                            @error('estimate_return_date')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group">
                        <div class="mt-3 text-center">
                            <button type="submit" class="btn btn-primary">Issue</button>
                        </div>
                    </div>

                    </form>
                </div>
            </div>

        </div>
        <div class="col-md-9">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>Book Title</th>
                            <th>Book Number</th>
                            <th>Issue Date</th>
                            <th title="estimate return date">ERD</th>
                            <th>Return Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if(!empty($bookissueLists))
                        @foreach($bookissueLists as $bookissue)
                            <tr>
                                <td>{{$bookissue->booklist->title}}</td>
                                <td>{{$bookissue->booklist->book_number}}</td>
                                <td>{{$bookissue->issue_date}}</td>
                                <td title="estimate return date">{{$bookissue->estimate_return_date}}</td>
                                <td>{{$bookissue->return_date}}</td>
                                <td>
                                    <button class="primary-btn small bg-success text-white border-0">{{$bookissue->status}}</button>
                                </td>
                                <td class="d-flex justify-content-start">
                                    @if($bookissue->status != 'returned')
                                    <button class="btn btn-sm btn-info mx-1" id="add-student-btn" data-toggle="modal" data-target="#dataEditModal"  data-id="{{ $bookissue->id }}">Return</button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        @endif
                    
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('book.return') }}">
                    @csrf
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Return Book</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <input type="hidden" id="id" name="id">
                        <div class="text-center mt-3 mb-4">
                            <h4>Are you sure to return this book?</h4>
                        </div>
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="btn btn-sm btn-primary" data-dismiss="modal">None</button>
                            <button class="btn btn-sm btn-success " type="submit">Yes</button>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

@stop

@push('scripts')
<script>
    $(document).ready(function () {
        document.getElementById('estimate_return_date').value = new Date().toISOString().substring(0, 10);
    })

    $('#dataEditModal').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('#id').val(id)
    })

</script>
@endpush

