@extends('layouts.master')
@section('styles')
<style>
    /* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
</style>
@endsection
@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Edit Book</h6>
            <div class="m-0 float-right">
                <a href="{{ route('booklist.index') }}" class="btn btn-sm btn-primary">Book List</a>
            </div>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('booklist.update',$book->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title">Book Title <span class="text-danger">*</span></label>
                            <input type="text"class="form-control" id="title" name="title" value="{{ $book->title }}" required>
                            @error('title')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="book_number">Book Number</label>
                            <input type="text" class="form-control" id="book_number" name="book_number" value="{{ $book->book_number }}">
                            @error('book_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="isbn_number">ISBN Number</label>
                            <input type="text" class="form-control" id="isbn_number" name="isbn_number" value="{{ $book->isbn_number }}">
                            @error('isbn_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="publisher">Publisher</label>
                            <input type="text"  class="form-control" id="publisher" name="publisher" value="{{ $book->publisher }}">
                            @error('publisher')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="author">Author</label>
                            <input type="text" class="form-control" id="author" name="author" value="{{ $book->author }}">
                            @error('author')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="subject">Subject</label>
                            <input type="text" class="form-control" id="subject" name="subject" value="{{ $book->subject }}">
                            @error('subject')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="rack_number">Rack Number</label>
                            <input type="text" class="form-control" id="rack_number" name="rack_number" value="{{ $book->rack_number }}">
                            @error('rack_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="quantity">Quantity</label>
                            <input type="number" class="form-control" id="quantity" name="quantity" value="{{ $book->quantity }}">
                            @error('quantity')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="price">Price</label>
                            <input type="number" class="form-control" id="price" name="price" value="{{ $book->price }}">
                            @error('price')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="postdate">Post Date</label>
                            <input type="text" class="form-control date360" id="postdate" name="postdate" value="{{ view_date_format($book->postdate) }}">
                            @error('postdate')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{!! $book->description !!}</textarea>
                            @error('description')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>

            </form>
        </div>
    </div>
@endsection
@section('scripts')
<script>
    $(document).ready(function () {
        
        const today = new Date();
        $('.date360').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,      
            todayHighlight: true, 
        });

        document.getElementById("quantity").addEventListener("keyup", function() {
          this.value = this.value.replace(/[^0-9]/g,"");
        });

        document.getElementById("price").addEventListener("keyup", function() {
          this.value = this.value.replace(/[^0-9]/g,"");
        });
    })
</script>
@endsection