@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Book List</h6>
        <div class="m-0 float-right">
            <a href="{{ route('booklist.create') }}" class="btn btn-sm btn-primary">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>Book Title</th>
                            <th>Book Number</th>
                            <th>ISBN Number</th>
                            <th>Publisher</th>
                            <th>Author</th>
                            <th>Subject</th>
                            <th>Rack Number</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @php
                        $sn=1;
                    @endphp
                    @foreach($books as $book)
                        <tr>
                            <td>{{$book->title}}</td>
                            <td>{{$book->book_number}}</td>
                            <td>{{$book->isbn_number}}</td>
                            <td>{{$book->publisher}}</td>
                            <td>{{$book->author}}</td>
                            <td>{{$book->subject}}</td>
                            <td>{{$book->rack_number}}</td>
                            <td>{{$book->quantity}}</td>
                            <td>{{$book->price}}</td>
                            <td class="d-flex justify-content-start">
                                <a href="{{ route('booklist.edit', $book->id) }}" class="btn btn-sm btn-soft-info mx-1"><i class="fas fa-edit"></i></a>
                                <form action="{{ route('booklist.destroy', $book->id) }}" method="POST" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

