@extends('layouts.master')
@section('styles')
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
.member-type{
    text-transform: capitalize !important;
    border-radius: 15px !important;
    background-color: red !important;
}

select {
        font-size: 16px;
        color: #333;
        background-color: #f9f9f9;
        border: 1px solid #ccc;
        padding: 5px;
        border-radius: 5px;
    }

    select:focus {
        outline: none;
        border-color: #007bff;
    }

</style>
@endsection
@section('content')
@php
$search_value = '';
@endphp
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center border-bottom justify-content-between">
            <h6 class="m-0 table__top__txt">Create Member</h6>
            <div class="m-0 float-right">
                
            </div>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('bookmember.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row justify-content-center">
                    <div class="col-md-6 ">
                        <div class="form-group">
                            <label for="user_type">Member Type <span class="text-danger">*</span></label>
                            <select class="form-control select2 user_type" id="user_type" name="user_type" required>
                                <option value="">Select Member Type</option>
                                @foreach($user_types as $type)
                                <option class="member-type" value="{{ $type->user_type }}">{{ $type->user_type }}</option>
                                @endforeach
                            </select>
                            @error('user_type')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- //student  -->
                        <div id="student-block" class="d-none">
                            <div class="form-group">
                                <label for="student_class_id">Class <span class="text-danger">*</span></label>
                                {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
                                @error('student_class_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="section_id">Section</label>
                                {{ generateDropdown('', 'class="form-control student_class section_id select2" id="student_class" name="section_id"', $section_id, "Section") }}
                                @error('section_id')
                                    <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div id="name-block" class="form-group">
                            <label for="user_id">Name <span class="text-danger">*</span></label>
                            <select class="form-control select2 user_id" id="user_id" name="name" required>
                                <option value="">Select Name</option>
                            </select>
                            @error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="member_ud_id">Member ID <span class="text-danger">*</span></label>
                            <input type="text" name="member_ud_id" class="form-control" required>
                            @error('member_ud_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="row mt-3 flex justify-content-end">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>

            </form>
        </div>
    </div>
@endsection
@push('scripts')
<script>
    $('#user_type').on('change', function () {
        let user_type = $(this).val();
        console.log(user_type);
        if(user_type === 'student'){
            $("#student-block").addClass('d-block')
            $("#name-block").addClass('d-none')
        }
        if (user_type) {
            $.ajax({
                url: "{{ route('userByType') }}/" + user_type,
                type: 'GET',
                success: function (data) {
                    $('#user_id').empty();
                    $('#user_id').append('<option value="">-- Select Name --</option>');
                    $.each(data, function (key, user) {
                        $('#user_id').append('<option value="' + user.id + '">' + user.name + '</option>');
                    });
                }
            });
        } else {
            $('#user_id').empty();
            $('#user_id').append('<option value="">-- Select Name --</option>');
        }
    });
</script>


<script>
    $('.student_class').on('change', function(){
        let student_class_id = $('.student_class').val();
        console.log(student_class_id);
        getSection(student_class_id);
    });
    
    let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
    let section_id = "{{ isset($section_id) ? $section_id : '' }}";

    if(student_class_id!=''){
        getSection(student_class_id);
        getSubjects(student_class_id);
    }

    function getSection(student_class_id){

        let section_id = "{{ isset($section_id) ? $section_id : '' }}";
        if(student_class_id){
            $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let sections = response;
                let option = '<option value="">--Select Section--</option>';
                for(let i=0;i<sections.length;i++){
                    if(sections[i].student_class_id == student_class_id){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }

                    }
                }
                console.log(option);
                $('select.section_id').empty().append(option);
            });
        }
    }




</script>

@endpush