@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Issue Books</h6>
        <div class="m-0 float-right">
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>SL</th>
                            <th>Name</th>
                            <th>Member Type</th>
                            <th>Member ID</th>
                            <th>Mobile</th>
                            <th style="width: 200px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @php
                        $sn=1;
                    @endphp
                        @if(!empty($members))
                        @if($members->isNotEmpty())
                        @foreach($members as $member)
                        <tr>
                            <td>{{ $sn }}</td>
                            <td>{{$member->user->name}}</td>
                            <td>{{$member->user->user_type}}</td>
                            <td>{{$member->member_ud_id}}</td>
                            <td>{{$member->user->phone_number}}</td>
                            <td class="d-flex justify-content-start">
                                <a href="{{ route('book.issue', $member->id) }}" class="btn btn-sm btn-info mx-1">Issue/Return Book</a>
                            </td>
                        </tr>
                        @endforeach
                        @else
                            <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

