@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Add Notice</h6>
            <a href="{{ route('notice.index') }}" class="btn btn-sm btn-light-blue">View All</a>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="card-body">
            <form action="{{ route('notice.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="title">Title <span class="text-danger">*</span></label>
                            <input type="text" maxlength="250" name="title" value="{{ old('title') }}" required
                                   class="form-control">
                            @error('title')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="student_class_id">Class</label>
                            <select class="form-control select2" name="student_class_id[]" id="student_class_id"
                                    multiple>
                                @foreach($studentClasses as $id => $className)
                                    <option
                                        value="{{ $id }}" {{ in_array($id, old('student_class_id', [])) ? 'selected' : '' }}>
                                        {{ $className }}
                                    </option>
                                @endforeach
                            </select>

                            @error('student_class_id')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description"
                                      name="description">{{ old('description') }}</textarea>
                            @error('description')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Attachment</label>
                            <input name="attachment" value="{{ old('attachment') }}" id="attachment" type="file"
                                   class="dropify" data-default-file="{{ old('attachment') }}"/>
                            @error('attachment')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                </div>

                <div class="row mt-3 flex justify-content-end">
                    <a href="{{ route('notice.index') }}" class="btn btn-default mr-2">Discard</a>
                    <button type="submit" id="submit" class="btn btn-submit">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#description').summernote({
                height: 150
            });
            $('.dropify').dropify({
                messages: {
                    'default': 'Drag and drop a file here or click',
                    'replace': 'Drag and drop or click to replace',
                    'remove': 'Remove',
                    'error': 'Ooops, something wrong happended.'
                }
            });
        })

        document.addEventListener('DOMContentLoaded', () => {
            const addressField = document.getElementById('description');
            // Load saved data from local storage
            const savedAddress = localStorage.getItem('description');
            if (savedAddress) {
                addressField.value = savedAddress;
            }
            // Save data to local storage on input
            addressField.addEventListener('input', () => {
                localStorage.setItem('description', addressField.value);
            });
        });

    </script>
@endsection
