@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Notice List</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="{{route('notice.create')}}">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th class="text-center">ID</th>
                            <th class="text-left" style="min-width: 450px">Title</th>
                            <th>Published</th>
                            <th>Class</th>
                            <th>Attachment</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($notices->isNotEmpty())
                            @foreach ($notices as $notice)
                                <tr>
                                    <td class="text-center">{{ $notice->id }}</td>
                                    <td class="text-left">{{ $notice->title }}</td>
                                    <td>{{ view_date_format($notice->publish_date) }}</td>
                                    <td>
                                        @if($notice->studentClasses->isEmpty())
                                            <span class="text-muted">All Classes</span>
                                        @else
                                            @foreach($notice->studentClasses as $class)
                                                <span class="badge badge-primary">{{ $class->class_name }}</span>
                                            @endforeach
                                        @endif

                                    </td>
                                    <td>
                                        @if ($notice->attachment)
                                            <a class="btn btn-sm btn-info" href="{{ asset($notice->attachment) }}" target="_blank">Attachment</a>
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td class="d-flex justify-content-start">
                                       <a class="btn btn-sm btn-soft-success" href="{{route('notice.show',['id'=>$notice->id])}}" ><i class="fas fa-eye"></i></a>
                                        <a class="btn btn-sm btn-soft-info mx-1" href="{{route('notice.edit',['id'=>$notice->id])}}" ><i class="fas fa-edit"></i></a>
                                        <form action="{{ route('notice.destroy', $notice->id) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-soft-danger btn-sm"
                                                onclick="return confirm('Are you sure you want to delete this notice?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                        <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop
