@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <a class="btn btn-sm btn-light-blue" href="{{route('notice.index')}}">Notice List</a>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="{{route('notice.create')}}">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <tbody>
                        @if(!empty($notice))
                        <tr>
                            <th>Title</th>
                            <td>{{ $notice->title }}</td>
                        </tr>
                        <tr>
                            <th>Class</th>
                            <td>
                                @if($notice->studentClasses->isNotEmpty())
                                    @foreach($notice->studentClasses as $class)
                                        <span class="badge badge-primary">{{ $class->class_name }}</span>
                                    @endforeach
                                @else
                                    <span class="text-muted">All Classes</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Attachment</th>
                            <td>
                                @if ($notice->attachment)
                                    <a class="btn btn-sm btn-info" href="{{ asset($notice->attachment) }}" target="_blank">Attachment</a>
                                @else
                                    N/A
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{!! $notice->description !!}</td>
                        </tr>
                        <tr>  
                            <th>Action</th>
                            <td class="d-flex justify-content-start">
                                <a class="btn btn-sm btn-soft-info mx-1" href="{{route('notice.edit',['id'=>$notice->id])}}" ><i class="fas fa-edit"></i></a>
                                <form action="{{ route('notice.destroy', $notice->id) }}" method="POST"
                                    class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                        onclick="return confirm('Are you sure you want to delete this notice?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop