@extends('layouts.master')
@section('content')

    @if (isset($subjectsAssigns))
        <div class="card">
            <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
                <a class="btn btn-sm btn-success" href="{{ route('class_time_periods.index') }}">Rutine list</a>
                <button class="btn btn-sm btn-info" onclick="printDiv('portrait')">Print</button>
            </div>

            <div class="card-body">
                <form action="{{ route('class_time_periods.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table_content">
                                    <thead class="thead-light">
                                        <th>SN</th>
                                        <th>Subject</th>
                                        <th>Teacher</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Room No</th>
                                    </thead>
                                    <tbody>
                                        @php
                                            $sn = 0;
                                        @endphp
                                        @foreach ($subjectsAssigns as $key=>$subject)
                                            <tr>
                                                <td>{{++$sn}}</td>
                                                <td>{{$subject->subject->subject_name}}</td>
                                                
                                                <td>
                                                    @php
                                                        $teacher_id = '';
                                                        if(isset($subject->teacher_id)){
                                                            if(array_key_exists($subject->teacher_id, $teachers)){
                                                                echo $teachers[$subject->teacher_id];
                                                            }
                                                        }
                                                    @endphp
                                                </td>

                                                <td>
                                                    {{$subject->start_time ? date('h:i A', strtotime($subject->start_time)) : ''}}
                                                </td>

                                                <td>
                                                    {{$subject->end_time ? date('h:i A', strtotime($subject->end_time)) : ''}}
                                                </td>

                                                <td>
                                                    {{$subject->class_room_id ?? ''}}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                
                </form>
            </div>
        </div>
    @endif
@stop

