@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Edit Marks</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-primary" href="{{ route('marks.index') }}">Marks List</a>
        </div>
    </div>
        @if ($errors->any())
        <div class="alert alert-danger m-3">
            <ul class="m-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        <div class="row justify-content-center">
            <div class="col-md-12">
                <form method="POST" action="{{route('marks.update',$check_recoard->id)}}">
                    @csrf
                    @method('put')
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Student Name</th>
                                    <th>Section</th>
                                    <th>Roll</th>
                                    @php
                                    
                                        $head_marks_array = json_decode($assignedMarksHead->head_marks, true);
                                        $head_id_array = array_keys($head_marks_array);
                                    @endphp
                                    @if (isset($head_id_array))
                                        @foreach ($markHeads as $head)
                                            @if (in_array($head->id,$head_id_array))
                                                <th style="width: 15%;">{{$head->short_name}}({{$head_marks_array[$head->id]}})</th>
                                            @endif
                                        @endforeach
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{$students->first_name}} {{$students->last_name}}<input type="hidden" name="student_id" value="{{$students->id}}"></td>
                                    <td>{{$students->section?->section_name}}</td>
                                    <td>{{$students->class_roll}}</td>
                                    @if (isset($head_marks_array) && !empty($check_recoard))
                                        @php
                                            $head_wise_marks = json_decode($check_recoard->head_wise_marks);
                                        @endphp
                                        @foreach ($markHeads as $head)
                                            @if (in_array($head->id, $head_id_array))
                                                <td class="w-15">
                                                    @if (isset($head_wise_marks->{$head->id}))
                                                        <input type="number" name="marks[{{ $students->id }}][]" value="{{ $head_wise_marks->{$head->id} }}" class="form-control">
                                                    @else
                                                        <input type="number" name="marks[{{ $students->id }}][]" value="" class="form-control">
                                                    @endif
                                                    <input type="hidden" value="{{ $head->id }}" name="head_id[{{ $students->id }}][]" class="form-control">
                                                </td>
                                            @endif
                                        @endforeach
                                    @elseif (isset($head_id_array))
                                        @foreach ($markHeads as $head)
                                            @if (in_array($head->id, $head_id_array))
                                                <td>
                                                    <input type="text" name="marks[{{ $students->id }}][]" value="" class="form-control">
                                                    <input type="hidden" value="{{ $head->id }}" name="head_id[{{ $students->id }}][]" class="form-control">
                                                </td>
                                            @endif
                                        @endforeach
                                    @endif
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="form-group mb-3 mr-4 flex d-flex justify-content-end mt-2">
                        <a href="{{ route('marks.index') }}" class="btn btn-secondary mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
</div>
@stop