@extends('layouts.master')
@section('content')
    <div class="card marks__entry__head">
        <div class="card-header py-3 card__head">
            <form method="POST" action="{{ route('students_marks_list') }}" >
                @csrf
                <div class="row">
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                            <option value="">Exam</option>
                            @foreach ($exams as $exam)
                                <option value="{{ $exam->id }}" {{ $loop->first ? 'selected' : '' }}>
                                    {{ $exam->exam_name . ' ' . $exam->academic_year->year }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        <select name="shift_id" class="form-control shift_id" id="shift_id" required>
                            <option value="">Shift</option>
                            @foreach ($shifts as $shift)
                                <option value="{{ $shift->id }}" {{ $loop->first ? 'selected' : '' }}>
                                    {{ $shift->shift_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        {{ generateDropdown($studentClasses, 'class="form-control select2 student_class student_class_id" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
                    </div>

                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
                    </div>

                    
                    <x-group-selector name="group_id" label="" labelText="Group" col="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6" 
                    :student_class_id="$student_class_id" :required="$student_class_id >= 11" :selected="old('group_id') ?? $group_id"/>

                    <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                        {{ generateDropdown('', 'class="form-control subject_id" id="subject_id" name="subject_id" required', '', "Subject") }}
                    </div>
                    <div  class="col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6 btn__search">
                        <div class="form-group">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Mark List</h6>
            <div class="m-0 float-right">
                @can('exam-result.marks-list.create')
                    <a href="{{ route('marks.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
                @endcan
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    @if ($marks && $assignedMarksHead)
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Roll</th>
                                    <th>Name</th>
                                    {{-- <th>Exam</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Year</th> --}}
                                    <th>Subject</th>
                                    <th>Full Marks</th>
                                    <th>Separate <br> Marks</th>
                                    <th>Total obtain</th>
                                    <th>Highest Marks</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $head_marks_array = json_decode($assignedMarksHead->head_marks, true);
                                    $head_id_array = array_keys($head_marks_array);
                                @endphp
                                {{-- @dd($marks) --}}
                                @foreach ($marks as $mark)
                                    @php
                                        $head_wise_marks = json_decode($mark->head_wise_marks);
                                        $total_obtain = 0;
                                        $full_marks = 0;
                                        $head_wise_obtain = '';
                                    @endphp
                                    <tr>
                                        <td>{{ $mark->student?->class_roll }}</td>
                                        <td style="white-space: nowrap;">
                                            {{ $mark->student?->first_name . ' ' . $mark->student?->last_name }} </td>
                                        {{-- <td>{{ $mark->exam?->exam_name }}</td>
                                    <td>{{ $mark->studentClass?->class_name }}</td>
                                    <td>{{ $mark->section?->section_name }}</td>
                                    <td>{{ $mark->academicYear?->year }}</td> --}}
                                        <td style="white-space: nowrap;">{{ $mark->subject?->subject_name }}</td>
                                        @foreach ($markHeads as $head)
                                            @if (in_array($head->id, $head_id_array))
                                                @php
                                                    $full_marks += $head_marks_array[$head->id];
                                                @endphp
                                            @endif
                                        @endforeach
                                        @foreach ($head_wise_marks as $head => $single_marks)
                                            @if (!empty($single_marks))
                                                @php
                                                    $total_obtain += $single_marks;
                                                    $marks_heads = $markHeads->pluck('short_name', 'id');
                                                    $head_wise_obtain .= "<span style='background-color: rgb(198, 253, 240); white-space: nowrap;' class='btn btn-sm mr-1' > $marks_heads[$head] = $single_marks  </span>";
                                                @endphp
                                            @endif
                                        @endforeach

                                        <td>{{ $full_marks }}</td>
                                        <td class="align-middle">
                                            <div class="d-flex align-items-center">
                                                {!! $head_wise_obtain !!}
                                            </div>
                                        </td>
                                        <td>{{ $total_obtain }}</td>
                                        <td>{{ $highest_marks }}</td>
                                        <td class="d-flex justify-content-start">
                                            @can('exam-result.marks-list.edit')
                                                <a class="btn btn-sm btn-soft-info mr-1"
                                                    href="{{ route('marks.edit', $mark->id) }}"><i class="fas fa-edit"></i></a>
                                            @endcan
                                            @can('exam-result.marks-list.delete')
                                                <button class="btn btn-sm btn-soft-danger"
                                                    onclick="marksDelete(event, {{ $mark->id }})"><i
                                                        class="fas fa-trash"></i></button>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    @else
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Roll</th>
                                    <th>Name</th>
                                    {{-- <th>Exam</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Year</th> --}}
                                    <th>Subject</th>
                                    <th>Full Marks</th>
                                    <th>Separate <br> Marks</th>
                                    <th>Total obtain</th>
                                    <th>Highest Marks</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8">
                                        <h5 class="text-center">There is no data accourding to your search. Please entry
                                            Mark's by going to 'Add New'.</h5>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
    </div>
@stop


@section('scripts')
    <script>
        $('.student_class').on('change', function() {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
            getSubjects(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if (student_class_id != '') {
            getSection(student_class_id);
            getSubjects(student_class_id);
        }

        function getSection(student_class_id) {

            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function(response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }

        //------------------Get Class Wise Subject List----------------

        function getSubjects(student_class_id) {
            let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";
            if (student_class_id) {
                $.get('{{ route('subjects.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function(response) {
                    let subjects = response;

                    let option = '<option value="">Subject</option>';
                    for (let i = 0; i < subjects.length; i++) {
                        if (subjects[i].student_class_id == student_class_id) {
                            if (subject_id == subjects[i].subject_id) {
                                option += '<option value=' + subjects[i].subject_id + ' selected>' + subjects[i]
                                    .subject.subject_name + '</option>';
                            } else {
                                option += '<option value=' + subjects[i].subject_id + ' >' + subjects[i].subject
                                    .subject_name + '</option>';
                            }
                        }
                    }
                    $('select.subject_id').empty().append(option);
                });
            }
        }

        const marksDelete = (event, marks_id) => {
            event.preventDefault();
            if (confirm('Are you sure you want to delete these marks?')) {
                if (marks_id) {
                    const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                    $.post("{{ route('marks.destroy') }}", {
                        _token: csrfToken,
                        marks_id: marks_id,
                    }, function(response) {
                        if (response.success) {
                            toastr.success(response.message, 'Success');
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        }
                    });
                }
            } else {
                return false;
            }

        }
    </script>
@endsection