@extends('layouts.master')
@section('content')
<div class="card marks__entry__head">
    <div class="card-header py-3 card__head">
        <form class="row" method="post" action="{{ route('teacher.marks.entry.create') }}">
            @csrf
            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-12">
                <select name="exam" class="form-control" id="exam" required>
                    <option value="{{ $exam->id ?? '' }}">
                        {{ $exam->exam_name ?? ''}} {{ $exam->academic_year->year ?? 'N/A' }}
                    </option>
                </select>
            </div>

            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-12">
                <select name="related_id" class="form-control select2" id="related_id" required>
                    <option value="">--Select Subject--</option>
                    @if ($my_subjects)
                        @foreach ($my_subjects as $subject)
                         @php
                            $value = $subject->teacher_id.','.$subject->student_class_id.','.$subject->subject_id.','.$subject->section_id.','.$subject->shift_id.','.$subject->branch_id;
                        @endphp

                            <option {{ (isset($relatedId) && $relatedId == $value) ? 'selected' : '' }}  value="{{ $value }}">
                                {{$subject->subject->subject_name ?? ''}}
                                ({{$subject->studentClass->class_name ?? ''}}
                                {{$subject->section->section_name ?? ''}})
                            </option>
                        @endforeach
                    @endif
                </select>
            </div>

            <div class="col-md-1 col-12 col-md-12 col-lg-12 col-xl-1 btn__search">
                <div class="form-group">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </div>
        </form>
    </div>
</div>


@if (isset($students))
<div class="card mt-4 marks__entry__body">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <form method="POST" action="{{ route('teacher.marks.store') }}" class="form-inline">
                @csrf
                <div class="table-responsive">
                    @if($assignedMarksHead)
                        <input type="hidden" name="exam_id" value="{{$exam_id ?? ''}}">
                        <input type="hidden" name="student_class_id" value="{{$student_class_id ?? ''}}">
                        <input type="hidden" name="shift_id" value="{{$shift_id ?? ''}}">
                        <input type="hidden" name="branch_id" value="{{$branch_id ?? ''}}">
                        <input type="hidden" name="section_id" value="{{$section_id ?? ''}}">
                        <input type="hidden" name="subject_id" value="{{$subject_id ?? ''}}">
                        <input type="hidden" name="group_id" value="{{$group_id ?? ''}}">
                        <input type="hidden" name="academic_year" value="{{$academic_year ?? ''}}">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Roll</th>
                                    <th class="th__name">Name</th>
                                    @php
                                        $head_marks_array = json_decode($assignedMarksHead->head_marks, true);
                                    @endphp
                                    @foreach ($markHeads as $head)
                                        @if (isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null)
                                            <th class="th__marks__entry" style="width: 10%; max-width: 10%; overflow: hidden;">
                                                {{ $head->short_name }}({{ $head_marks_array[$head->id] }})
                                            </th>
                                        @endif
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($students as $student)
                                    <tr>
                                        <td>{{ $student->class_roll }}</td>
                                        <td>
                                            {{ $student->first_name }} {{ $student->last_name }}
                                            <input type="hidden" name="student_id[]" value="{{ $student->id }}">
                                        </td>

                                        @php
                                            $head_wise_marks = $student->examRecords->isNotEmpty()
                                                ? json_decode($student->examRecords->first()->head_wise_marks, true)
                                                : [];
                                        @endphp

                                        @foreach ($markHeads as $head)
                                            @if (isset($head_marks_array[$head->id]) && $head_marks_array[$head->id] !== null)
                                                <td class="w-15">
                                                    <input
                                                        type="number"
                                                        name="marks[{{ $student->id }}][]"
                                                        value="{{ $head_wise_marks[$head->id] ?? '' }}"
                                                        class="form-control"
                                                        oninput="this.value = Math.abs(this.value)"
                                                        onchange="MinMaxInput(this, 0, {{ $head_marks_array[$head->id] }}, true)"
                                                    >
                                                    <input type="hidden" value="{{ $head->id }}" name="head_id[{{ $student->id }}][]" class="form-control">
                                                </td>
                                            @endif
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <h5>Mark's head is not assigned for this Exam/Class yet. Please assign Mark's head, and then try.</h5>
                    @endif
                </div>
                @if($assignedMarksHead)
                <div class="form-group flex d-flex w-100 justify-content-end">
                    <button type="submit" class="btn btn-info m-4">Save</button>
                </div>
                @endif
            </form>
        </div>
    </div>
</div>
@endif


@stop
@section('scripts')
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
            getSubjects(student_class_id)
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
            getSubjects(student_class_id)
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }

        //------------------Get Class Wise Subject List----------------

        function getSubjects(student_class_id){
            let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";
            if(student_class_id){
                $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let subjects = response;

                    let option = '<option value="">Subject</option>';
                    for(let i=0;i<subjects.length;i++){
                        if(subjects[i].student_class_id == student_class_id){
                            if(subject_id==subjects[i].subject_id){
                                option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                            }else{
                                option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                            }

                        }
                    }
                    $('select.subject_id').empty().append(option);
                });
            }
        }
        function MinMaxInput(element, min, max, zeroAllowed){

            if(element.value == 0 && zeroAllowed)
                return;

            if(element.value > max){
                element.value = max;
                return;
            }

            if(element.value < min){
                element.value = min;
                return;
            }

        }

    </script>
@endsection
