@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Copy Assign Head</h5> <a href="{{ route('markHeadAssign.index') }}" class="btn btn-sm btn-light-blue">Assign Head List</a>
    </div>
    <div class="row">
        <div class="col-md-6 offset-md-3 mt-2">
            @if ($errors->any())
                <div class="alert alert-danger m-3">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>

    <div class="card-body">
        <form method="post" action="{{ route('markHeadAssign.searchUpdate') }}" class="row">
            @csrf
            <div class="form-group col-lg-3 col-md-4 col-sm-6">
                <label for="exam" class="col-form-label text-md-right">Exam * :</label>
                {{ generateDropdown($exam,'class="form-control select2" name="exam" required', '', 'Select Option') }}
            </div>
            <div class="form-group col-lg-3 col-md-4 col-sm-6">
                <label for="student_class" class="col-form-label text-md-right">Student Class * :</label>
                {{ generateDropdown($studentClasses,'class="form-control select2" id="student_class" name="student_class" required', $student_class_id) }}
            </div>

            <div class="form-group col-lg-5 col-md-5 col-sm-6">
                <label for="mark_head" class="col-form-label">Marks Heads * :</label> <small>(You can select multiple head.)</small>
                <select class="form-control form-control select2 select2-hidden-accessible" id="mark_head" name="mark_head[]" multiple="multiple" required>
                    @foreach($mark_heads as $head)
                        @if (in_array($head->id, $mark_head))
                            <option value="{{ $head->id }}" selected>{{ $head->head_name }} - {{ $head->short_name }}</option>
                        @else
                            <option value="{{ $head->id }}">{{ $head->head_name }} - {{ $head->short_name }}</option>
                        @endif
                    @endforeach
                </select>
            </div>
            <div class="form-group col-lg-1 col-md-1 col-sm-1 mt-4">
                <button type="submit" class="btn btn-primary float-md-right">Filter</button>
            </div>
        </form>
    </div>

    @if(isset($subjects_assigns))
    <form action="{{ route('markHeadAssign.store') }}" method="POST">
        @csrf

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                            <th>Subject Name</th>
                            @if (empty($filter_mark_heads))

                                @foreach ($mark_head as $head_id)
                                    <th>{{$marks_heads[$head_id]}}</th>
                                @endforeach

                            @else
                                @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                    <th>{{$filter_mark_head->short_name}}</th>
                                @endforeach
                            @endif
                        </thead>
                        <tbody>
                            @foreach ($assignMarksHead[$student_class_id] as $index => $a_head)
                                @php
                                    $head_marks = json_decode($a_head->head_marks, true);
                                @endphp
                                <tr>

                                    <td>
                                        {{$a_head->subject->subject_name}}
                                        <input type="hidden" name="subject_id[]" value="{{$a_head->subject->id}}">
                                    </td>
                                    @if (empty($filter_mark_heads))
                                        @foreach ($head_marks as $head_id => $marks)
                                            @php
                                                $head_name = isset($mark_heads[$head_id]) ? $mark_heads[$head_id] : 'Unknown Head';
                                            @endphp

                                            <td>
                                                <input type="hidden" name="head_id[{{$a_head->subject->id}}][]" value="{{$head_id}}">
                                                <input type="number" min="0" oninput="this.value = Math.abs(this.value)" class="form-control" name="marks[{{$a_head->subject->id}}][]" value="{{$marks}}" placeholder="Enter head marks">
                                            </td>
                                        @endforeach
                                    @else
                                        @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                            <td>
                                                <input type="hidden" name="head_id[{{$a_head->subject->id}}][]" value="{{$filter_mark_head->id}}">
                                                <input type="number" min="0" oninput="this.value = Math.abs(this.value)" class="form-control" name="marks[{{$a_head->subject->id}}][]" placeholder="Enter head marks">
                                            </td>
                                        @endforeach
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-6 offset-md-6">
                <input type="hidden" name="exam_id" value="{{ $exam_id }}">
                <button type="submit" class="btn btn-primary mt-2 float-md-right">Update</button>
            </div>
        </div>
    </form>
    @endif
</div>
@endsection

@section('scripts')

@endsection
