@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assign Heads</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="{{ route('markHeadAssign.index') }}">View All</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 offset-md-3 mt-2">
            @if ($errors->any())
                <div class="alert alert-danger m-3">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
    <div class="card-body card__head">
        <form method="post" action="{{ route('markHeadAssign.search') }}" class="row">
            @csrf
            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                <label for="exam" class="col-form-label text-md-right">Exam <span class="text-danger">*</span> </label>
                <select name="exam" class="form-control select2 exam_id" id="exam" required>
                    <option value="">Exam</option>
                    @foreach ($exams as $examItem)
                        <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first)) >
                            {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                        </option>
                    @endforeach 
                </select>
            </div>
            <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                <label for="student_class" class="col-form-label text-md-right">Student Class <span class="text-danger">*</span> </label>
                {{ generateDropdown($studentClasses,'class="form-control select2" id="student_class" name="student_class" required', $student_class_id) }}
            </div>
            <div class="form-group col-lg-3 col-md-12 col-sm-12">
                <div class="row">
                    <div class="col-md-12">
                        <label for="mark_head" class="col-form-label">Marks Heads <span class="text-danger">*</span> </label> <small>(You can select multiple head.)</small>
                    </div>
                    <div class="col-md-10 col-sm-9 col-9">
                        <select class="form-control form-control select2 select2-hidden-accessible" id="mark_head" name="mark_head[]" multiple="multiple" required>
                            @foreach($mark_heads as $head)
                                @if (in_array($head->id,$mark_head))
                                    <option value="{{ $head->id }}" selected>{{ $head->head_name }} - {{ $head->short_name }}</option>
                                @else
                                    <option value="{{ $head->id }}">{{ $head->head_name }} - {{ $head->short_name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2 col-sm-3 col-3">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@if ($filter_mark_heads && $subjects_assigns != null && $assignMarksHead->isEmpty())
<div class="card mt-4">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        Entry Marks
    </div>
    <div class="card-body">
        <form action="{{ route('markHeadAssign.store') }}" method="POST">
            @csrf
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                                <th>SN</th>
                                <th>Subject Name</th>
                                @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                    <th>{{$filter_mark_head->short_name}}</th>
                                @endforeach
                            </thead>
                            <tbody>
                                @php
                                    $sn = 0;
                                @endphp
                                @foreach ($subjects_assigns as $key=>$subjects)
                                    <tr>
                                        <td>{{++$sn}}</td>
                                        <td><input type="hidden" name="subject_id[]" value="{{$subjects->subject->id}}"> {{$subjects->subject->subject_name}}</td>
                                        @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                            <td>
                                                <input type="hidden" name="head_id[{{$subjects->subject->id}}][]" value="{{$filter_mark_head->id}}">
                                                <input type="number" min="0" oninput="this.value = Math.abs(this.value)" class="form-control" name="marks[{{$subjects->subject->id}}][]" placeholder="Enter head marks">
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <hr>
            @if ($filter_mark_heads && $subjects_assigns != null)
                <div class="row">
                    <div class="col-md-6 offset-md-6">
                        <input type="hidden" name="exam_id" value="{{$exam_id}}">
                        <input type="hidden" name="student_class_id" value="{{$student_class_id}}">
                        <button type="submit" class="btn btn-submit mt-2 float-md-right">Save</button>
                    </div>
                </div>
            @endif
        </form>
    </div>
</div>
@elseif (!empty($assignMarksHead))
<div class="card mt-4">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        Entry Marks
    </div>
    <div class="card-body">
        <h4>Head wise marks already assigned to this class. You can edit/delete this.</h4>
        <table class="table">
            <thead class="thead-light">
                <tr>
                    <th>Class</th>
                    <th class="text-left">Subject</th>
                    <th class="text-left">Head Marks</th>
                    <th class="text-left">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($assignMarksHead as $assign_heads)
                    @foreach ($assign_heads as $index => $a_head)
                        @php
                            $head_marks = json_decode($a_head->head_marks, true);
                        @endphp
                        <tr>
                            @if ($index==0)
                                <td rowspan="{{count($assign_heads)}}">{{$a_head->studentClass->class_name}}</td>
                            @endif
                            <td class="text-left">{{$a_head->subject->subject_name}}</td>
                            <td class="text-left">
                                {{-- @foreach ($head_marks as $head) --}}
                                    @foreach ($head_marks as $head_id => $marks)
                                        @php
                                            $head_name = isset($marks_heads[$head_id]) ? $marks_heads[$head_id] : 'Unknown Head';
                                        @endphp
                                        <span class="badge badge-light p-2 m-1"> {{ $head_name }}: {{ $marks }}</span>
                                    @endforeach
                                {{-- @endforeach --}}
                            </td>
                            @if ($index==0)
                                <td class="text-left" rowspan="{{count($assign_heads)}}">
                                    <a href="{{route('markHeadAssign.edit',[$a_head->studentClass->id, $exam_id])}}" class="btn btn-light-blue btn-sm mr-1">Edit</a>
                                    <form action="{{ route('markHeadAssign.destroy', [$a_head->studentClass->id, $exam_id]) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm mt-3" onclick="return confirm('Are you sure you want to delete this class?')">Delete</button>
                                    </form>
                                </td>
                            @endif
                        </tr>
                    @endforeach
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif
@endsection
@section('scripts')
<script>
    // $('#mark_head').select2();
</script>
@endsection