@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assign Heads </h6>
        <div class="m-0 float-right">
            <a href="{{ route('markHeadAssign.index') }}" class="btn btn-sm btn-light-blue">Assign Head List</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 offset-md-3 mt-2">
            @if ($errors->any())
                <div class="alert alert-danger m-3">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>

    <div class="card-body card__head">
        <form method="post" action="{{ route('markHeadAssign.searchUpdate') }}" class="row">
            @csrf
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <label for="exam" class="col-form-label text-md-right">Exam <span class="text-danger">*</span> </label>
                <select name="exam" class="form-control select2 exam_id" id="exam" required>
                    <option value="">Exam</option>
                    @foreach ($exams as $examItem)
                        <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first)) >
                            {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                        </option>
                    @endforeach 
                </select>
            </div>
            <div class="form-group col-lg-3 col-md-6 col-sm-6">
                <label for="student_class" class="col-form-label text-md-right">Student Class <span class="text-danger">*</span> </label>
                {{ generateDropdown($studentClasses,'class="form-control select2" id="student_class" name="student_class" required', $student_class_id) }}
            </div>
    
            <div class="form-group col-lg-6 col-md-12 col-sm-12">
                <div class="row">
                    <div class="col-md-12">
                        <label for="mark_head" class="col-form-label">Marks Heads <span class="text-danger">*</span> </label> <small>(You can select multiple head.)</small>
                    </div>
                    <div class="col-md-10 col-sm-9 col-9">
                        <select class="form-control form-control select2 select2-hidden-accessible" id="mark_head" name="mark_head[]" multiple="multiple" required>
                    @foreach($mark_heads as $head)
                        @if (in_array($head->id, $mark_head))
                            <option value="{{ $head->id }}" selected>{{ $head->head_name }} - {{ $head->short_name }}</option>
                        @else
                            <option value="{{ $head->id }}">{{ $head->head_name }} - {{ $head->short_name }}</option>
                        @endif
                    @endforeach
                </select>
                    </div>
                    <div class="col-md-2 col-sm-3 col-3">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="card mt-4">
    @if(isset($subjects_assigns))
    <form action="{{ route('markHeadAssign.update', $student_class_id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                            <th>Subject Name</th>
                            @if (empty($filter_mark_heads))
        
                                @foreach ($mark_head as $head_id)
                                    <th>{{$marks_heads[$head_id]}}</th>
                                @endforeach
                                
                            @else
                                @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                    <th>{{$filter_mark_head->short_name}}</th>
                                @endforeach
                            @endif
                        </thead>
                        <tbody>
                            @foreach ($assignMarksHead[$student_class_id] as $index => $a_head)
                                @php
                                    $head_marks = json_decode($a_head->head_marks, true);
                                @endphp
                                <tr>
                                    
                                    <td>
                                        {{$a_head->subject->subject_name}}
                                        <input type="hidden" name="subject_id[]" value="{{$a_head->subject->id}}"> 
                                    </td>
                                    @if (empty($filter_mark_heads))
                                        @foreach ($head_marks as $head_id => $marks)
                                            @php
                                                $head_name = isset($mark_heads[$head_id]) ? $mark_heads[$head_id] : 'Unknown Head';
                                            @endphp
                                            
                                            <td>
                                                <input type="hidden" name="head_id[{{$a_head->subject->id}}][]" value="{{$head_id}}">
                                                <input type="number" min="0" oninput="this.value = Math.abs(this.value)" class="form-control" name="marks[{{$a_head->subject->id}}][]" value="{{$marks}}" placeholder="Enter head marks">
                                            </td>
                                        @endforeach
                                    @else
                                        @foreach ($filter_mark_heads as $key=>$filter_mark_head)
                                            <td>
                                                <input type="hidden" name="head_id[{{$a_head->subject->id}}][]" value="{{$filter_mark_head->id}}">
                                                <input type="number" min="0" oninput="this.value = Math.abs(this.value)" class="form-control" name="marks[{{$a_head->subject->id}}][]" placeholder="Enter head marks">
                                            </td>
                                        @endforeach
                                    @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-6 offset-md-6">
                <input type="hidden" name="exam_id" value="{{ $exam_id }}">
                <button type="submit" class="btn btn-submit mb-3 mr-3 float-md-right">Update</button>
            </div>
        </div>
    </form>
    @endif
</div>
@endsection

@section('scripts')

@endsection
