@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="get" action="{{ route('markHeadAssign.index') }}" class="row">
                <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                    <select name="exam" class="form-control select2 exam_id" id="exam" required>
                        <option value="">Select Exam</option>
                        @foreach ($exams as $examItem)
                            <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first))>
                                {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                    {{ generateDropdown($studentClasses, 'class="form-control select2" id="student_class" name="student_class"', $student_class_id, 'Select Class') }}
                </div>
                <div class="form-group col-lg-2 col-md-3 col-sm-3">
                    <button type="submit" class="btn btn-info">Search</button>
                    <a class="btn btn-success" href="{{ route('markHeadAssign.copy.create') }}">Copy</a>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Assigned List</h6>
            <div class="m-0 float-right">
                @can('exam-result.assign-head.create')
                    <a class="btn btn-sm btn-light-blue" href="{{ route('markHeadAssign.create') }}">Add New</a>
                @endcan
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-left">Exam</th>
                                <th class="text-left">Class</th>
                                <th class="text-left">Subject</th>
                                <th class="text-left">Head Marks</th>
                                <th class="action__col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($assignMarksHead->isNotEmpty())

                                @foreach ($assignMarksHead as $classGroups)
                                    {{-- removed department loop --}}
                                    @foreach ($classGroups as $index => $a_head)
                                        @php
                                            $head_marks = json_decode($a_head->head_marks, true);
                                        @endphp

                                        <tr>
                                            @if ($index == 0)
                                                <td class="text-left" rowspan="{{ $classGroups->count() }}">
                                                    {{ $a_head->exam->exam_name }}
                                                    {{ $a_head->exam->academic_year->year }}
                                                </td>

                                                <td class="text-left" rowspan="{{ $classGroups->count() }}">
                                                    {{ $a_head->studentClass->class_name }}
                                                </td>
                                            @endif

                                            <td class="text-left">
                                                {{ $a_head->subject->subject_name }}
                                            </td>

                                            <td class="text-left">
                                                @foreach ($head_marks as $head_id => $marks)
                                                    <span class="badge badge-light p-2 m-1">
                                                        {{ $mark_heads[$head_id] ?? 'Unknown Head' }}: {{ $marks }}
                                                    </span>
                                                @endforeach
                                            </td>

                                            @if ($index == 0)
                                                <td rowspan="{{ $classGroups->count() }}">
                                                    @can('exam-result.assign-head.edit')
                                                        <a href="{{ route('markHeadAssign.edit', [$a_head->studentClass->id, $a_head->exam_id]) }}"
                                                            class="btn btn-soft-info btn-sm mr-1">
                                                            <i class="fas fa-edit"></i>
                                                        </a>

                                                        <form
                                                            action="{{ route('markHeadAssign.destroy', [$a_head->studentClass->id, $a_head->exam_id]) }}"
                                                            method="POST" class="d-inline">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure?')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    @endcan
                                                </td>
                                            @endif
                                        </tr>
                                    @endforeach
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center">
                                        There is no data. Search with exam & class to see list.
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop
