@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Assign Heads Copy</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-light-blue" href="{{ route('markHeadAssign.index') }}">Assigned List</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 offset-md-3 mt-2">
            @if ($errors->any())
                <div class="alert alert-danger m-3">
                    <ul class="m-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>

    <div class="card-body card__head">
        <form method="post" action="{{ route('markHeadAssign.copy.store') }}">
            @csrf
            <div class="form-row">
                <!-- Original Exam -->
                <div class="col-12 col-md-4 mb-3">
                  <label for="original_exam" class="form-label">Original Exam <span class="text-danger">*</span></label>
                  <select name="original_exam" id="original_exam" class="form-control select2 w-100" required>
                      @foreach ($original_exams as $exam)
                          <option value="{{ $exam->id }}" {{ old('original_exam') == $exam->id ? 'selected' : '' }}>
                              {{ $exam->exam_name . ' ' . $exam->year }}
                          </option>
                      @endforeach
                  </select>
                </div>
              
                <!-- Copied Exam -->
                <div class="col-12 col-md-4 mb-3">
                  <label for="copied_exam" class="form-label">Copied Exam <span class="text-danger">*</span></label>
                  <select name="copied_exam" id="copied_exam" class="form-control select2 w-100" required>
                    @foreach ($copied_exams as $exam)
                      <option value="{{ $exam->id }}" {{ old('copied_exam') == $exam->id ? 'selected' : '' }}>
                        {{ $exam->exam_name . ' ' . $exam->year}}
                      </option>
                    @endforeach
                  </select>
                </div>
              
                <!-- Submit Button -->
                <div class="col-12 col-md-4 d-flex align-items-end mb-3">
                  <button type="submit" class="btn btn-info w-100">
                    Copy
                  </button>
                </div>
              </div>
        </form>
    </div>
</div>
@endsection
