@extends('layouts.master')
@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        body {
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }

        a {
            text-decoration: none;
        }

        .container {
            max-width: 860px;
            padding: 20px 0;
            margin: auto;

        }

        .first-row {
            padding: 20px 10px;
            background-color: transparent;
            border: 3px double #ccc;
        }

        table,
        th,
        td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        .first-table-wrapper {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 15px;
        }

        .left-side {
            text-align: center;
        }

        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }

        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }

        .result-table tbody tr,
        .third-table-wrapper .work-information table tbody tr,
        .third-table-wrapper .conduct-info table tbody tr,
        .last-table-wrapper table tbody tr {
            /*height:34px;*/
        }

        .result-table {
            border: 2px solid #565656;
            margin-top: 20px;
        }

        .second-and-third-wrapper {
            /* height: 560px; */
        }

        .second-table-wrapper {
            margin-top: 25px;
        }

        .third-table-wrapper {
            display: flex;
            gap: 20px;
            margin-top: 25px;
        }

        .last-table-wrapper {
            margin-top: 25px;
        }

        .sig {
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }

        table tr td {
            padding-left: 5px;
        }

        .col-height {
            height: 34px;
        }

        .bg-gray {
            background-color: #e9e9e9;
        }

        /*//water-mark*/
        .container .first-row {
            position: relative;
        }

        .container .first-row .ms__icon {
            /* background-image: url({{ asset('/default/icon-marksheet1.png') }}); */
            position: absolute;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            width: 349px;
            height: 349px;
            opacity: .15;
            left: 37%;
            top: 48%;
        }
    </style>
    <div class="card">
        <div class="card-body card__head">
            <form method="GET" action="{{ route('marks.sheet') }}" class="row">
                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                        <option value="">Exam</option>
                        @foreach ($exams as $examItem)
                            <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first))>
                                {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <select name="shift_id" class="form-control select2 shift_id" id="shift_id" required>
                        <option value="">Shift</option>
                        @foreach ($shifts as $shift)
                            <option value="{{ $shift->id }}" @selected($shift_id == $shift->id || (!$shift_id && $loop->first))>
                                {{ $shift->shift_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control select2 student_class student_class_id" id="student_class" name="student_class_id" required', request()->student_class_id, 'Class') }}
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" ', request()->section_id, 'Section') }}
                </div>

                <x-group-selector name="group_id" label="" labelText="Group"
                    col="form-group col-lg-2 col-md-6 col-sm-6" :student_class_id="(int) request()->student_class_id" :required="(int) request()->student_class_id >= 11" :selected="old('group_id') ?? request()->group_id" />


                {{-- <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', request()->group_id, 'Group') }}
                </div> --}}


                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </form>
        </div>
    </div>

    @if (isset($students) && !empty($students))
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Mark Sheet (Total Result: {{ count($students) }})</h6>
                <div class="m-0 float-right">
                    <a class="btn btn-secondary btn__export mr-1" href="#" data-toggle="tooltip"
                        onclick="printMarkDiv()" title="Print">
                        <i class="fas fa-print"></i>
                    </a>
                    {{-- <x-report-actions :export_pdf="true" /> --}}
                </div>
            </div>
            <div class="card-body table_content">
                @php
                
                    $get_branch_info = get_branch_info();
                    $logo = get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('uploads/images/logo.png') ?? '';
                    $principal_signature = get_setting_value(Settings::PRINCIPAL_SIGNATURE) ? asset(get_setting_value(Settings::PRINCIPAL_SIGNATURE)) : '' ?? '';
    

                    $grades_str = '';
                    foreach ($grades as $grade) {
                        $grades_str .= "<tr>
                                            <td align='center'>$grade->mark_from-$grade->mark_to</td>
                                            <td align='center'>$grade->name</td>
                                            <td align='center'>$grade->remark</td>
                                        </tr>";
                    }

                    $head_marks_array = json_decode($assignedMarksHead->first(), true);
                    $head_id_array = array_keys($head_marks_array);
                    $subject_head_marks = $assignedMarksHead;
                    $highest_grand_total_obtain = 0;

                @endphp

                @foreach ($students as $key => $student)
                    @php
                        $examRecords = $student->examRecords;
                        $singleRecord = $examRecords->first();
                        // dd($singleRecord);
                    @endphp

                    @if ($examRecords->isNotEmpty())
                        @php
                            $grand_total = 0;
                            $grand_total_obtain = 0;
                            $fail_count = 0;
                            $exam = $exam;
                            $head_wise_grand_total = [];
                            $section = $sections[$singleRecord->section_id] ?? '';
                            $class = $studentClasses[$singleRecord->class_id] ?? '';
                            $academicYear = $academicYears[request()->academic_year] ?? '';
                        @endphp
                        <section class="page-section">
                            <div class="container">
                                <div class="first-row">
                                    <div class="ms__icon"></div>
                                    <div class="first-table-wrapper">
                                        <div class="left-side" style="width: 30%;">
                                            <p>{{get_setting_value(Settings::SCHOOL_NAME)}}</p>
                                            <div class="first-table-wrapper">
                                                <img src="{{ asset($logo) }}" height="135"
                                                    width="200" alt="">
                                            </div>
                                        </div>
                                        <div class="middle-side" style="width: 30%;">
                                            <div class="student-information">
                                                <table border="1" width="100%" height="250px">
                                                    <tr>
                                                        <th colspan="2" align="center">Student Information</th>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">ID</th>
                                                        <td align="center">{{ $student->student_id_no }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Name</th>
                                                        <td align="center" class="">{{ $student->first_name }}
                                                            {{ $student->last_name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Session</th>
                                                        <td align="center">{{ $exam->academic_year->year ?? '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Class</th>
                                                        <td align="center">{{ $class }} @if ($student->group_id)
                                                                {{ '(' . $student->group->group_name . ')' }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Section</th>
                                                        <td align="center">{{ $section }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Roll</th>
                                                        <td align="center">{{ $student->class_roll }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="right-side" style="width: 40%;">
                                            <div class="Grade-referance">
                                                <table border="1" width="100%" height="250px">
                                                    <tr>
                                                        <th colspan="3" align="center">Grade Referance</th>
                                                    </tr>
                                                    <tr>
                                                        <th align="center">Marks(%)</th>
                                                        <th align="center">Grade</th>
                                                        <th align="center">Comments</th>
                                                    </tr>
                                                    {!! $grades_str !!}
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="second-and-third-wrapper">
                                        <div class="second-table-wrapper">
                                            <table class="result-table" width="100%">

                                                <tr>
                                                    <th rowspan="2">Subject</th>
                                                    <th rowspan="2" class="bg-gray">Full <br> Marks</th>
                                                    <th colspan="{{ count($head_id_array) + 3 }}"
                                                        class="text-center col-height">{{ $exam->exam_name ?? '' }}
                                                        {{ $exam->academic_year->year ?? '' }}</th>
                                                </tr>

                                                <tr align="center">
                                                    @if (isset($head_id_array))
                                                        @foreach ($markHeads as $head)
                                                            @if (in_array($head->id, $head_id_array))
                                                                <th>{{ $head->short_name }}</th>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                    <th>Total Obt.</th>
                                                    <th>Grade</th>
                                                    <th>Heighest marks</th>
                                                </tr>

                                                @if (!empty($student->group_id))
                                                    {{-- //group wise student subject show --}}
                                                    @foreach ($student->StudentInfoSubjectClass as $subjects_assign)
                                                        @php
                                                            $subject_id = $subjects_assign->subject_id;
                                                            $recoards = $examRecords->firstWhere(
                                                                'subject_id',
                                                                $subject_id,
                                                            );

                                                            $full_marks = 0;
                                                            $head_wise_total_obtain = [];
                                                            $total_marks_obtain = 0;
                                                            $head_records_str = '';

                                                            $head_wise_marks_record = $recoards
                                                                ? json_decode($recoards->head_wise_marks)
                                                                : null;
                                                            $head_marks_data = $subject_head_marks[$subject_id] ?? '{}';
                                                            $head_marks_array = json_decode($head_marks_data);
                                                        @endphp

                                                        <tr align="center">
                                                            <td align="left">
                                                                {{ $subjects_assign->subject->subject_name }} @if ($subjects_assign->subject_type == 'optional')
                                                                    <span class="text-danger">(4<sup>th</sup>)</span>
                                                                @endif</td>

                                                            @if ($head_wise_marks_record)
                                                                @foreach ($markHeads as $head)
                                                                    @if (in_array($head->id, $head_id_array))
                                                                        @php
                                                                            $full_marks +=
                                                                                $head_marks_array->{$head?->id} ?? 0;
                                                                            $head_records_str .=
                                                                                '<td>' .
                                                                                ($head_wise_marks_record->{$head?->id} ??
                                                                                    '0') .
                                                                                '</td>';
                                                                            $total_marks_obtain +=
                                                                                $head_wise_marks_record->{$head?->id} ??
                                                                                0;
                                                                            $head_wise_grand_total[$head?->id] =
                                                                                ($head_wise_grand_total[$head?->id] ??
                                                                                    0) +
                                                                                ($head_wise_marks_record->{$head?->id} ??
                                                                                    0);
                                                                        @endphp
                                                                    @endif
                                                                @endforeach

                                                                <td class="bg-gray">{{ $full_marks }}</td>
                                                                {!! $head_records_str !!}

                                                                @php
                                                                    $grand_total_obtain += $total_marks_obtain;
                                                                    $grand_total += $full_marks;
                                                                @endphp
                                                            @else
                                                                @php
                                                                    $full_marks = 0;
                                                                    // First: calculate full marks
                                                                    foreach ($markHeads as $head) {
                                                                        if (in_array($head->id, $head_id_array)) {
                                                                            $full_marks +=
                                                                                $head_marks_array->{$head->id} ?? 0;
                                                                        }
                                                                    }
                                                                    $grand_total += $full_marks;
                                                                @endphp

                                                                {{-- Show full marks first --}}
                                                                <td class="bg-gray">{{ $full_marks }}</td>
                                                                {{-- Then render the placeholder marks --}}
                                                                @foreach ($markHeads as $head)
                                                                    @if (in_array($head->id, $head_id_array))
                                                                        <td>0</td>
                                                                    @endif
                                                                @endforeach
                                                            @endif

                                                            <td>{{ $total_marks_obtain }}</td>

                                                            @php
                                                                $subject_grade_name = '';
                                                                $total_percentage =
                                                                    $total_marks_obtain > 0 && $full_marks > 0
                                                                        ? round(
                                                                            ($total_marks_obtain * 100) / $full_marks,
                                                                        )
                                                                        : 0;
                                                                foreach ($grades as $grade) {
                                                                    if (
                                                                        $grade->mark_from <= $total_percentage &&
                                                                        $grade->mark_to >= $total_percentage
                                                                    ) {
                                                                        $subject_grade_name = $grade->name;
                                                                        if ($subject_grade_name == 'F') {
                                                                            $fail_count++;
                                                                        }
                                                                    }
                                                                }
                                                            @endphp

                                                            <td>{{ $subject_grade_name }}</td>
                                                            <td>
                                                                @if (array_key_exists($subject_id, $highest_marks_array))
                                                                    {{ round($highest_marks_array[$subject_id]) }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    @foreach ($subjects_assigns as $subjects_assign)
                                                        @php
                                                            $subject_id = $subjects_assign->subject_id;
                                                            $recoards = $examRecords->firstWhere(
                                                                'subject_id',
                                                                $subject_id,
                                                            );

                                                            $full_marks = 0;
                                                            $head_wise_total_obtain = [];
                                                            $total_marks_obtain = 0;
                                                            $head_records_str = '';

                                                            $head_wise_marks_record = $recoards
                                                                ? json_decode($recoards->head_wise_marks)
                                                                : null;
                                                            $head_marks_data = $subject_head_marks[$subject_id] ?? '{}';
                                                            $head_marks_array = json_decode($head_marks_data);
                                                        @endphp

                                                        <tr align="center">
                                                            <td align="left">
                                                                {{ $subjects_assign->subject->subject_name }}</td>

                                                            @if ($head_wise_marks_record)
                                                                @foreach ($markHeads as $head)
                                                                    @if (in_array($head->id, $head_id_array))
                                                                        @php
                                                                            $full_marks +=
                                                                                $head_marks_array->{$head?->id} ?? 0;
                                                                            $head_records_str .=
                                                                                '<td>' .
                                                                                ($head_wise_marks_record->{$head?->id} ??
                                                                                    '0') .
                                                                                '</td>';
                                                                            $total_marks_obtain +=
                                                                                $head_wise_marks_record->{$head?->id} ??
                                                                                0;
                                                                            $head_wise_grand_total[$head?->id] =
                                                                                ($head_wise_grand_total[$head?->id] ??
                                                                                    0) +
                                                                                ($head_wise_marks_record->{$head?->id} ??
                                                                                    0);
                                                                        @endphp
                                                                    @endif
                                                                @endforeach

                                                                <td class="bg-gray">{{ $full_marks }}</td>
                                                                {!! $head_records_str !!}

                                                                @php
                                                                    $grand_total_obtain += $total_marks_obtain;
                                                                    $grand_total += $full_marks;
                                                                @endphp
                                                            @else
                                                                @php
                                                                    $full_marks = 0;
                                                                    // First: calculate full marks
                                                                    foreach ($markHeads as $head) {
                                                                        if (in_array($head->id, $head_id_array)) {
                                                                            $full_marks +=
                                                                                $head_marks_array->{$head->id} ?? 0;
                                                                        }
                                                                    }
                                                                    $grand_total += $full_marks;
                                                                @endphp

                                                                {{-- Show full marks first --}}
                                                                <td class="bg-gray">{{ $full_marks }}</td>
                                                                {{-- Then render the placeholder marks --}}
                                                                @foreach ($markHeads as $head)
                                                                    @if (in_array($head->id, $head_id_array))
                                                                        <td>0</td>
                                                                    @endif
                                                                @endforeach
                                                            @endif

                                                            <td>{{ $total_marks_obtain }}</td>

                                                            @php
                                                                $subject_grade_name = '';
                                                                $total_percentage =
                                                                    $total_marks_obtain > 0 && $full_marks > 0
                                                                        ? round(
                                                                            ($total_marks_obtain * 100) / $full_marks,
                                                                        )
                                                                        : 0;
                                                                foreach ($grades as $grade) {
                                                                    if (
                                                                        $grade->mark_from <= $total_percentage &&
                                                                        $grade->mark_to >= $total_percentage
                                                                    ) {
                                                                        $subject_grade_name = $grade->name;
                                                                        if ($subject_grade_name == 'F') {
                                                                            $fail_count++;
                                                                        }
                                                                    }
                                                                }
                                                            @endphp

                                                            <td>{{ $subject_grade_name }}</td>
                                                            <td>
                                                                @if (array_key_exists($subject_id, $highest_marks_array))
                                                                    {{ round($highest_marks_array[$subject_id]) }}
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @endif






                                                {{-- @foreach ($examRecords as $recoards)
                                                    @php
                                                        $full_marks = 0;
                                                        $head_wise_total_obtain = [];
                                                        $total_marks_obtain = 0;
                                                        $head_records_str = '';

                                                        $head_wise_marks_record = json_decode($recoards->head_wise_marks);

                                                        $head_marks_data = $subject_head_marks[$recoards->subject->id];
                                                        $head_marks_array = json_decode($head_marks_data);

                                                    @endphp
                                                    <tr align="center">
                                                        <td align="left">{{$recoards->subject->subject_name}}</td>

                                                        @if (isset($head_wise_marks_record))

                                                            @foreach ($markHeads as $head)
                                                                @if (in_array($head->id, $head_id_array))
                                                                    @php
                                                                        $full_marks += $head_marks_array->{$head?->id};
                                                                        $head_records_str .= "<td>".($head_wise_marks_record?->{$head?->id} ?? "-")."</td>";
                                                                        $total_marks_obtain += $head_wise_marks_record?->{$head?->id} ?? 0;
                                                                        $head_wise_grand_total[$head?->id] = ($head_wise_grand_total[$head?->id] ?? 0) + ($head_wise_marks_record?->{$head?->id} ?? 0);
                                                                    @endphp
                                                                @endif
                                                            @endforeach

                                                            <td class="bg-gray">{{$full_marks}}</td>
                                                            {!!$head_records_str!!}

                                                            @php
                                                                $grand_total_obtain += $total_marks_obtain;
                                                                $grand_total += $full_marks;
                                                            @endphp

                                                        @endif

                                                        <td>{{$total_marks_obtain}}</td>
                                                        @php
                                                            $subject_grade_name = "";
                                                            $grade_name_remarks = "";
                                                            $total_percentage = ($total_marks_obtain>0 && $full_marks>0) ? round((($total_marks_obtain*100)/$full_marks)) : 0;
                                                            foreach ($grades as $grade){
                                                                if($grade->mark_from<=$total_percentage && $grade->mark_to>=$total_percentage){
                                                                    $subject_grade_name = $grade->name;
                                                                    if($subject_grade_name=='F'){
                                                                        $fail_count++;
                                                                    }
                                                                }
                                                            }
                                                        @endphp
                                                        <td>{{ $subject_grade_name }}</td>
                                                        <td>
                                                            @if (array_key_exists($recoards->subject->id, $highest_marks_array))
                                                                {{round($highest_marks_array[$recoards->subject->id])}}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach --}}

                                                @php
                                                    if ($grand_total_obtain > $highest_grand_total_obtain) {
                                                        $highest_grand_total_obtain = $grand_total_obtain;
                                                    }
                                                @endphp

                                                <tr align="center">
                                                    <td align="left"> <b>Grand Total</b></td>
                                                    <td class="bg-gray"><b>{{ $grand_total }}</b></td>
                                                    @foreach ($markHeads as $head)
                                                        @if (in_array($head->id, $head_id_array))
                                                            <th>{{ $head_wise_grand_total[$head->id] }}</th>
                                                        @endif
                                                    @endforeach
                                                    <td> <b>{{ $grand_total_obtain }}</b></td>
                                                    <td></td>
                                                    <td>{{ array_sum($highest_marks_array) }}</td>
                                                </tr>

                                                @php
                                                    $grade_name = '';
                                                    $grade_name_remarks = '';
                                                    $grand_total_percentage =
                                                        $grand_total_obtain > 0 && $grand_total > 0
                                                            ? round(($grand_total_obtain * 100) / $grand_total)
                                                            : 0;
                                                    foreach ($grades as $grade) {
                                                        if (
                                                            $grade->mark_from <= $grand_total_percentage &&
                                                            $grade->mark_to >= $grand_total_percentage
                                                        ) {
                                                            $grade_name = $grade->name;
                                                            $grade_name_remarks = $grade->remark;
                                                        }
                                                    }

                                                @endphp

                                                <tr align="center">
                                                    <td class="col-height" align="left"> <b>Percentage</b> </td>
                                                    <td colspan="{{ count($head_id_array) + 4 }}">
                                                        <b>{{ round($grand_total_percentage, 2) }}%</b>
                                                    </td>
                                                </tr>
                                                <tr align="center">
                                                    <td class="col-height" align="left"><b>Grade</b></td>
                                                    <td colspan="{{ count($head_id_array) + 4 }}">
                                                        @if ($fail_count > 0)
                                                            <b>F</b>
                                                        @else
                                                            <b>{{ $grade_name }}</b>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>

                                        <div class="third-table-wrapper">
                                            <div class="work-information" style="width: 40%;">
                                                <table border="1" width="100%">

                                                    <tr>
                                                        <td style="width: 50%">Working Days</td>
                                                        <td style="width: 50%"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Present</td>
                                                        <td>{{ '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Absent</td>
                                                        <td>{{ '' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Remarks</td>
                                                        <td></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Result Published</td>
                                                        <td>{{ $publish_date }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="conduct-info" style="width: 60%;">
                                                <table border="1" width="100%">

                                                    <tr>
                                                        <td style="width: 50%">Conduct</td>
                                                        <td style="width: 50%"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Moral Development</td>
                                                        <td></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Discipline</td>
                                                        <td></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Hand Writing</td>
                                                        <td></td>
                                                    </tr>
                                                    <tr>
                                                        <td>General Remark</td>
                                                        <td>{{ $grade_name_remarks }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="last-table-wrapper">
                                        <table border="1" width="100%">
                                            <tr>
                                                <th>Class Teacher's Signature</th>
                                                <th>Principle's Signature</th>
                                                <th>Guardian's Signature</th>
                                            </tr>
                                            <tr>
                                                <td class="sig" style="height: 30px"></td>
                                                <td class="sig">
                                                    <img width="150px"
                                                            src="{{ asset($principal_signature) }}"
                                                            alt="Principal Signature" />
                                                </td>
                                                <td class="sig"></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="page-break"></div>
                        </section>
                    @endif
                @endforeach
            </div>

        </div>
    @endif
@endsection


@section('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var highestGrandTotalObtain = {{ $highest_grand_total_obtain ?? 0 }};
            var elements = document.querySelectorAll('.highest-grand-total');
            elements.forEach(function(element) {
                element.innerHTML = '<b>' + highestGrandTotalObtain + '</b>';
            });
        });

        $('.student_class').on('change', function() {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {

            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function(response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }


        function printMarkDiv() {
            let htmlToPrint = '';
            let divToPrint = document.getElementsByClassName("table_content");
            const newWin = window.open("");

            htmlToPrint = `<style type="text/css" media="print">
                            @page { size: a4; }
                            .hide-btn{
                                visibility: hidden;
                            }
                            @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

                            body{
                                font-family: "Roboto", sans-serif;
                                font-style: normal;
                            }
                            a{
                                text-decoration: none;
                            }

                            .container{
                                max-width: 860px;
                                padding: 20px 0;
                                margin: auto;

                            }
                            .first-row{
                                padding: 20px 10px;
                                background-color: transparent;
                                border: 3px double #ccc;
                            }
                            table,th,td {
                                border: 1px solid black;
                                border-collapse: collapse;
                            }
                            .first-table-wrapper{
                                display: flex;
                                gap: 20px;
                                justify-content: center;
                                margin-top: 15px;
                            }
                            .left-side{
                                text-align: center;
                            }
                            .left-side h2 {
                                font-size: 22px;
                                width: 266px;
                            }
                            .left-side a {
                                padding: 8px 10px;
                                color: #fff;
                                display: inline-block;
                                border-radius: 4px;
                                cursor: pointer;
                            }
                            .result-table{
                                border: 2px solid #565656;
                                margin-top: 20px;
                            }
                            .result-table tbody tr,
                            .third-table-wrapper .work-information table tbody tr,
                            .third-table-wrapper .conduct-info table tbody tr,
                            .last-table-wrapper table tbody tr{
                                // height:34px;
                            }
                            .second-and-third-wrapper{
                                height: 560px;
                            }
                            .second-table-wrapper{
                                margin-top: 25px;
                            }
                            .third-table-wrapper{
                                display: flex;
                                gap: 20px;
                                margin-top: 25px;
                            }
                            .last-table-wrapper{
                                margin-top: 25px;
                            }
                            .sig{
                                font-family: "Dancing Script", cursive;
                                font-weight: 600;
                                text-align: center;
                            }
                            table tr td{
                                padding-left: 5px;
                            }
                            .col-height{
                                height: 34px;
                            }
                            .bg-gray{
                                background-color: #e9e9e9;
                            }
                            .page-break {
                                page-break-after: always;
                            }
                            .container .first-row{
                                position: relative;
                            }
                            .container .first-row .ms__icon{
                                background: url(https://edueasy.jabalunnur.com/default/icon-marksheet1.png) ;
                                position: absolute;
                                background-repeat: no-repeat;
                                background-position: center;
                                background-size: contain;
                                width: 349px;
                                height: 349px;
                                opacity: .15;
                                left: 37%;
                                top: 48%;
                            }
                        </style>`;

            newWin.document.write(htmlToPrint);

            newWin.document.write(divToPrint[0].outerHTML);
            newWin.document.close();
            // newWin.print();
            // newWin.close();
            setTimeout(function() {
                newWin.print();
                newWin.close();
            }, 90);
        }

        const exportPdfOptions = {
            url: '{{ route('marks_sheet_download') }}',
            filename: 'marks-sheet',
            extraData: @json(request()->query()),
        };
    </script>
@endsection
