@extends('layouts.master')
@section('content')
    <style>
        /* .seat-plan-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        } */
        .seat-plan-wrapper {
            border: 1px solid #585858;
            font-family: sans-serif;
            padding: 15px 5px 5px;
            box-sizing: border-box;
            height: 287px;
            overflow: hidden;
            position: relative;
        }
        .seat-plan-wrapper h4 {
            color: #222222;
            font-weight: 600;
            font-size: 1.5rem;
            font-family: sans-serif !important;
        }
        .seat-plan-wrapper h5 {
            color: #000000;
            font-weight: 600;
            font-size: 1.1rem;
        }
        .seat-plan-wrapper .roll {
            font-weight: 700;
            font-size: 2rem;
            margin-bottom: 1rem;
            color: #000;
        }
        .seat-plan-wrapper .footer p {
            position: absolute;
            right: 5px;
            bottom: 5px;
        }
    </style>

    <div class="card">
        <div class="card-body card__head">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link {{ request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : '' }}"
                       data-toggle="tab" href="#search-tab">
                        Search By ID
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->input('tab') === 'filter' ? 'show active' : '' }}"
                       data-toggle="tab" href="#filter-tab">
                        Search by Class
                    </a>
                </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab"
                     class="tab-pane {{ request()->input('tab') === 'search' || request()->input('tab') === null ? 'show active' : '' }}">
                    <br>
                    <form method="post" action="{{ route('seat-plan.filter') }}" class="row">
                        @csrf
                        <input type="hidden" name="tab" value="search">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                @foreach ($exams as $exam)
                                    @if ($exam_id==$exam->id)
                                        <option value="{{$exam->id}}"
                                                selected>{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @else
                                        <option
                                            {{ $loop->first ? 'selected' : '' }} value="{{$exam->id}}">{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            @component('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => request()->student_id_no ?? '',
                                'required' => '',
                            ])
                            @endcomponent
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab"
                     class="tab-pane fade {{ request()->input('tab') === 'filter' ? 'show active' : '' }}"><br>
                    <form method="post" action="{{ route('seat-plan.filter') }}" class="row">
                        @csrf
                        <input type="hidden" name="tab" value="filter">

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <select name="exam" class="form-control select2" id="exam" required>
                                <option value="">Exam</option>
                                @foreach ($exams as $exam)
                                    @if ($exam_id==$exam->id)
                                        <option value="{{$exam->id}}"
                                                selected>{{$exam->exam_name ." ". $exam->academic_year->year }}</option>
                                    @else
                                        <option
                                            {{ $loop->first ? 'selected' : '' }} value="{{$exam->id}}">{{$exam->exam_name. " " .$exam->academic_year->year }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown($studentClasses, 'class="form-control student_class student_class_id select2" id="student_class" name="student_class" required', request()->input('student_class'), "Class") }}
                        </div>

                        
                      
                        <x-group-selector
                            name="group"
                            label=""
                            labelText="Group"
                            col="form-group col-lg-2 col-md-6 col-sm-6"
                            :student_class_id="(int) request()->input('student_class')"
                            :required="(int) request()->input('student_class') >= 11"
                            :selected="old('group') ?? request()->input('group')"
                        />


                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @if(isset($students) && !empty($students) && $students->count() > 0 )

        @php
            $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
            $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
            $branch_info = get_branch_info();
        @endphp
        <div class="card mt-4 justify-content-center">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">Seat Plan (Total Result: {{ count($students)}})</h6>
                <div class="m-0 float-right">
                    <a class="btn btn-secondary btn__export mr-1" href="#" data-toggle="tooltip"
                       @if(count($students) > 0)
                       onclick="prindAdmitCard()"
                       @else
                       onclick="return false;"
                       @endif title="Print">
                        <i class="fas fa-print"></i>
                    </a>
                </div>
            </div>

            <div class="card-body mt-3">
                <div class="seat-plan-container justify-content-center row" id="seat-plan">
                    @foreach ($students->sortBy('class_roll') as $student)
                        <div class="col-md-4 col-lg-4 items">
                            <div class="seat-plan-wrapper text-center">
                                <h4 class="name">{{ $institute_name }}</h4>
                                <h6 class="address">{{ $branch_info->address }}</h6>
                                <h4 class="exam__name">{{ $selected_exam->exam_name ?? 'N/A' }}  {{ $academic_year }} </h4>
                                <h5>Name: <span class="text-uppercase">{{ Str::words($student->name,3,'') }}</span></h5>
                                <div class="dept d-flex align-items-center justify-content-between">
                                    <h4>Class: {{ $student->studentClass->class_name ?? 'N/A' }}</h4>
                                    <h4>Roll No: {{ $student->class_roll ?? 'N/A' }}</h4>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
@endsection

@section('scripts')
    <script>
        function prindAdmitCard() {
            let content = document.getElementById('seat-plan').innerHTML;
            let printWindow = window.open('', '', 'height=900,width=1100');
            printWindow.document.write(`
        <html>
            <head>
                <style>
                    @media print {
                        body {
                            font-family: Arial, sans-serif;
                            margin: 0;
                            padding: 0;
                        }
                         .name{
                               margin-bottom: 5px;
                            }
                        .address{
                            margin-top: 5px !important;
                            margin-bottom: 9px;
                        }
                        .exam__name{
                        margin-top: 10px !important;
                        }
                        .dept{
                        margin-top: 16px;
                        }
                        .dept h4{
                        font-weight: 400;
                        }

                        /* Center the container */
                        #seat-plan {
                            text-align: left;
                        }

                        /* Each card item */
                        .items {
                            display: inline-block;
                            width: 32%;
                            vertical-align: top;
                            margin: 3px;
                            padding-top: .20rem;
                            padding-bottom: .20rem;
                            text-align: center;
                            box-sizing: border-box;
                        }

                     .seat-plan-wrapper {
                                border: 1px solid #585858;
                                font-family: sans-serif;
                                padding: 15px 5px 5px;
                                box-sizing: border-box;
                                height: 255px;
                                overflow: hidden;
                                position: relative;
                                display: inline-block;
                            }
                        .align-items-center{
                            -webkit-box-align: center !important;
                            -ms-flex-align: center!important;
                            align-items: center !important;
                        }
                        .justify-content-between {
                            -webkit-box-pack: justify !important;
                            -ms-flex-pack: justify!important;
                            justify-content: space-between !important;
                        }
                        .d-flex {
                            display: -webkit-box !important;
                            display: -ms-flexbox!important;
                            display: flex !important;
                        }

                        .seat-plan-wrapper h4{
                            color: #222222;
                            font-weight: 600;
                            font-size: 1rem;
                            margin:0px;
                            padding-bottom: 3px;

                        }
                        .seat-plan-wrapper h5{
                            color: #000000;
                            font-weight: 600;
                            font-size: 0.8rem;
                            margin:0px;
                            padding-bottom: 3px;
                        }
                        .seat-plan-wrapper h6{
                            font-size: 0.8rem;
                            margin:0px;
                            padding-bottom: 3px;
                        }
                        .seat-plan-wrapper .roll{
                            font-weight: 700;
                            font-size: 24px;
                            margin-top: 0.5rem;
                            margin-bottom: 0.7rem;
                            color: #000;
                            padding: 0px;
                        }
                        .text-right {
                            text-align: right !important;
                        }
                        .mb-0, .my-0 {
                            margin-bottom: 0 !important;
                        }
                        .small, small {
                            font-size: 80%;
                            font-weight: 400;
                        }
                        .footer{
                            color:#757575;
                        }
                        @page {
                            size: A4 portrait;
                            margin-top: 3mm;
                            margin-left: 3mm;
                            margin-right: 3mm;
                            margin-bottom: 3mm;
                        }
                    }
                </style>
            </head>
            <body>
                <div id="seat-plan">${content}</div>
            </body>
        </html>
    `);
            printWindow.document.close();
            printWindow.focus();

            setTimeout(() => {
                printWindow.print();
                printWindow.close();
            }, 500);
        }


    </script>
@endsection
