@extends('layouts.master')
@section('content')
<div class="card">
    <!-- Nav tabs -->
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" data-toggle="tab" href="#general-sms-tab" role="tab">General SMS</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#student-sms-tab" role="tab">Student SMS</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#employee-sms-tab" role="tab">Employee SMS</a>
        </li>
    </ul>

    <!-- Tab panes -->
    <div class="tab-content">
        <div id="general-sms-tab" class="tab-pane fade {{ request()->query('tab', 'general-sms') === 'general-sms' ? 'show active' : '' }}">
            <form action="{{route('general-sms.send')}}" method="POST">
                @csrf
                <div class="col-12 mt-2">
                    <label class="font-weight-bolder">Sender ID</label>
                    <div class="form-group">
                        <input type="text" class="form-control" value="8809617613336" readonly>
                    </div>
                </div>

                <div class="col-12 mt-1">
                    <label class="font-weight-bolder">Enter Mobile Numbers <span class="text-warning">(Use Comma for number separation. Don't use speace after/before comma.)</span></label>
                    <fieldset class="form-label-group mb-0">
                        <textarea data-length="160" class="form-control char-textarea" id="textarea-counter" rows="3"
                            placeholder="Ex : 01934115336,01870762474" name="mobile_number" required="" style="color: rgb(78, 81, 84);"></textarea>
                        <label for="textarea-counter"></label>
                    </fieldset>
                </div>

                <div class="col-12 mt-1 mb-2">
                    <label class="font-weight-bolder">Enter SMS Content </label>
                    <fieldset class="form-label-group mb-0">
                        <textarea class="form-control char-textarea" id="message" name="sms_body" rows="3" placeholder="Write your sms body here..."
                            style="color: rgb(78, 81, 84);"></textarea>
                        <label for="textarea-counter"></label>
                    </fieldset>
                    <small class="sms-count float-left">
                        <span id="length">0 characters</span> |
                        <span id="remaining">1530 Characters Left | </span>
                        <span id="messages" style="color: #f79622;font-weight: bold;"> 1 SMS </span>
                        <span id="smslen" style="color: #f79622;font-weight: bold;"> ( 160 Char./SMS ) </span>
                    </small>
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-submit submitBtn float-right btn-inline mb-2 waves-effect waves-float waves-light">Send
                        SMS</button>
                </div>
            </form>
        </div>

        <div id="student-sms-tab" class="tab-pane fade {{ request()->query('tab') === 'student-sms' ? 'show active' : '' }}">
            <div class="col-12 mt-2">
                <label class="font-weight-bolder">Sender ID</label>
                <div class="form-group">
                    <input type="text" class="form-control" value="8809617613336" readonly>
                </div>
            </div>
            <div class="col-12 mt-2">
                <form method="POST" action="{{ route('student-sms.search-student') }}" class="row g-3 align-items-center">
                    @csrf
                    <div class="col-lg col-md-4 col-sm-6">
                        {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, 'Shift') }}
                    </div>
                    <div class="col-lg col-md-4 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class_id student_class" id="student_class" name="student_class_id" required', $student_class_id, 'Class') }}
                    </div>
                    <div class="col-lg col-md-4 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
                    </div>
                    {{-- <div class="col-lg col-md-4 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, 'Group') }}
                    </div> --}}
                    <x-group-selector name="group_id" label="" labelText="Group" col="col-lg col-md-4 col-sm-6"
                                      :student_class_id="$student_class_id" :required="$student_class_id >= 11" :selected="old('group_id') ?? $group_id"/>

                    <div class="col-auto">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            
            
            <form action="{{ route('student-sms.send') }}" method="POST">
                @csrf
                <div class="col-12 mt-1">
                    <label class="font-weight-bolder">Enter Mobile Numbers <span class="text-warning">(Use Comma for number separation. Don't use space after/before comma.)</span></label>
                    <select name="mobile_number[]" id="mobile_numbers" class="form-control select2" multiple>
                        @if (!empty($students) && $students->count() > 0)
                            <option value="{{ $all_guardian_number }}">All Students</option>
                        @endif
                        @foreach ($students as $student)
                            <option value="{{ $student->guardian_mobile }}">
                                {{ $student->first_name . ' ' . $student->last_name }} ({{ $student->guardian_mobile }})
                            </option>
                        @endforeach
                    </select>
                </div>                    
                
                <div class="col-12 mt-2">
                    <label class="font-weight-bolder">Select SMS Type</label>
                    <ul class="list-unstyled mb-0">
                        <li class="d-inline-block mr-2">
                            <fieldset>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input testr" name="gn_sms_type" id="customRadio1" value="text" required="" checked="">
                                    <label class="custom-control-label" for="customRadio1">Text</label>
                                </div>
                            </fieldset>
                        </li>
                        <li class="d-inline-block mr-2">
                            <fieldset>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input testr" name="gn_sms_type" value="unicode" id="customRadio2" required="">
                                    <label class="custom-control-label" for="customRadio2">Unicode</label>
                                </div>
                            </fieldset>
                        </li>
                    </ul>
                </div>
                <div class="col-12 mt-2 mb-2">
                    <label class="font-weight-bolder">Enter SMS Content </label>
                    <fieldset class="form-label-group mb-0">
                        <textarea class="form-control char-textarea" id="message" name="sms_body" rows="3"
                            placeholder="Write your sms body here..." style="color: rgb(78, 81, 84);"></textarea>
                        <label for="textarea-counter"></label>
                    </fieldset>
                    <small class="sms-count float-left">
                        <span id="length">0 characters</span> |
                        <span id="remaining">1530 Characters Left | </span>
                        <span id="messages" style="color: #f79622;font-weight: bold;"> 1 SMS </span>
                        <span id="smslen" style="color: #f79622;font-weight: bold;"> ( 160 Char./SMS ) </span>
                    </small>
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary float-right btn-inline mb-2 waves-effect waves-float waves-light">Send
                        SMS</button>
                </div>
            </form>
        </div>

        <div id="employee-sms-tab"  class="tab-pane fade {{ request()->query('tab') === 'employee-sms' ? 'show active' : '' }}">
            <div class="col-12 mt-2">
                <label class="font-weight-bolder">Sender ID</label>
                <div class="form-group d-none">
                    <input type="text" class="form-control" value="8809617613336" readonly>
                    <input type="hidden" name="employee_type" value="{{$employee_type}}">
                </div>
            </div>
            <div class="col-12 mt-2">
                <form method="POST" action="{{ route('employee-sms.search-employee') }}" class="row">
                    @csrf
                    <div class="form-group col-lg-3 col-md-4 col-sm-6">
                        <select name="employee_type" class="form-control" required>
                            <option value="">Select Option</option>
                            <option value="all" {{$employee_type=='all' ? 'selected' : ''}}>All Employee</option>
                            <option value="teacher" {{$employee_type=='teacher' ? 'selected' : ''}}>Teacher</option>
                            <option value="staff" {{$employee_type=='staff' ? 'selected' : ''}}>Staff</option>
                        </select>
                    </div>
                    <div class="form-group col-lg-3 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info ">Search</button>
                    </div>
                </form>
            </div>
            <form action="{{ route('employee-sms.send') }}" method="POST">
                @csrf
                <div class="col-12 mt-1">
                    <label class="font-weight-bolder">Enter Mobile Numbers <span class="text-warning">(Use Comma for number separation. Don't use space after/before comma.)</span></label>
                    <select name="mobile_number[]" id="mobile_numbers" class="form-control select2" multiple>
                        @if (!empty($employees) && $employees->count()>0)
                            @if ($employee_type=='all')
                                <option value="{{ $all_employee_number }}">All Employee</option>
                            @elseif ($employee_type=='teacher')
                                <option value="{{ $all_employee_number }}">All Teacher</option>
                            @elseif ($employee_type=='staff')
                                <option value="{{ $all_employee_number }}">All Staff</option>
                            @endif
                            @foreach ($employees as $employee)
                                <option value="{{ $employee->phone_number }}">
                                    {{ $employee->first_name . ' ' . $employee->last_name }} ({{ $employee->phone_number }})
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
                <div class="col-12 mt-2">
                    <label class="font-weight-bolder">Select SMS Type</label>
                    <ul class="list-unstyled mb-0">
                        <li class="d-inline-block mr-2">
                            <fieldset>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input testr" name="gn_sms_type" id="customRadio1" value="text" required="" checked="">
                                    <label class="custom-control-label" for="customRadio1">Text</label>
                                </div>
                            </fieldset>
                        </li>
                        <li class="d-inline-block mr-2">
                            <fieldset>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input testr" name="gn_sms_type" value="unicode" id="customRadio2" required="">
                                    <label class="custom-control-label" for="customRadio2">Unicode</label>
                                </div>
                            </fieldset>
                        </li>
                    </ul>
                </div>
                <div class="col-12 mt-2 mb-2">
                    <label class="font-weight-bolder">Enter SMS Content </label>
                    <fieldset class="form-label-group mb-0">
                        <textarea class="form-control char-textarea" id="message" name="sms_body" rows="5"
                            placeholder="Write your sms body here..." style="color: rgb(78, 81, 84);"></textarea>
                        <label for="textarea-counter"></label>
                    </fieldset>
                    <small class="sms-count float-left">
                        <span id="length">0 characters</span> |
                        <span id="remaining">1530 Characters Left | </span>
                        <span id="messages" style="color: #f79622;font-weight: bold;"> 1 SMS </span>
                        <span id="smslen" style="color: #f79622;font-weight: bold;"> ( 160 Char./SMS ) </span>
                    </small>
                </div>

                <div class="col-12">
                    <button type="submit"
                        class="btn btn-primary float-right btn-inline mb-2 waves-effect waves-float waves-light">Send
                        SMS</button>
                </div>
            </form>
        </div>

    </div>


{{--     
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>General SMS List</h5> 
        @can('exam-result.publish-result.create')
            <a href="{{ route('general-sms.create') }}" class="btn btn-sm btn-primary">Send SMS</a>
        @endcan
    </div>
    <div class="card-body"> 
        <div class="table-responsive">
            <table class="table" id="dataTable">
                <thead class="thead-light">
                     <tr>
                        <th>Send From</th>
                        <th>Sent To</th>
                        <th>SMS</th>
                        <th>Cost</th>
                        <th>Send Time</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $total_cost = 0;
                    @endphp
                    @foreach ($generalSmsList as $sms)
                        @php
                            $total_cost += $sms->sms_cost;
                        @endphp
                        <tr>
                            <td>{{$sms->send_from}}</td>
                            <td>{{$sms->send_to}}</td>
                            <td>{{urldecode($sms->sms_text)}}</td>
                            <td>{{$sms->sms_cost}}</td>
                            <td>{{$sms->send_time}}</td>
                            <td> {!!getStatusBadge($sms->status)!!}</span> </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="table-info">
                        <td colspan="3">Total Cost</td>
                        <td>{{$total_cost}}</td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div> --}}
</div>


@endsection


@section('scripts')
    <script type="text/javascript">
        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });

    </script>


<script>
    $(document).ready(function () {
        var $remaining = $('#remaining'),
            $length = $('#length'),
            $smslen = $('#smslen'),
            $messages = $remaining.next();


        var $remainingfile = $('#remainingfile'),
            $lengthfile = $('#lengthfile'),
            $smslenfile = $('#smslenfile'),
            $messagesfile = $remainingfile.next();


        var $remaininggroup = $('#remaininggroup'),
            $lengthgroup = $('#lengthgroup'),
            $smslengroup = $('#smslengroup'),
            $messagesgroup = $remaininggroup.next();

        $('#message').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var chars = this.value.length;

            if (msgResponse == false) {
                $("#customRadio1").prop("checked", true);
                console.log(chars);
                if (chars <= 160) {
                    messages = Math.ceil(chars / 160),
                        $length.text(chars + ' characters');
                    $remaining.text((1530 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 160 Char./SMS )');
                } else {
                    messages = Math.ceil(chars / 153),
                        $length.text(chars + ' characters');
                    $remaining.text((1530 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio2").prop("checked", true);
                if (chars <= 70) {
                    messages = Math.ceil(chars / 70),
                        $length.text(chars + ' characters');
                    $remaining.text((670 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 70 Char./SMS )');
                } else {
                    messages = Math.ceil(chars / 67),
                        $length.text(chars + ' characters');
                    $remaining.text((670 - chars) + ' characters left | ');
                    $messages.text(messages + ' SMS');
                    $smslen.text('( 67 Char./SMS )');
                }

            }

        });


        $('#messagefile').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var charsfile = this.value.length;

            if (msgResponse == false) {
                $("#customRadio4").prop("checked", true);
                // console.log(chars);
                if (charsfile <= 160) {
                    messagesfile = Math.ceil(charsfile / 160),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((1530 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 160 Char./SMS )');
                } else {
                    messagesfile = Math.ceil(charsfile / 153),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((1530 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio6").prop("checked", true);
                if (charsfile <= 70) {
                    messagesfile = Math.ceil(charsfile / 70),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((670 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 70 Char./SMS )');
                } else {
                    messagesfile = Math.ceil(charsfile / 68),
                        $lengthfile.text(charsfile + ' characters');
                    $remainingfile.text((670 - charsfile) + ' characters left | ');
                    $messagesfile.text(messagesfile + ' SMS');
                    $smslenfile.text('( 68 Char./SMS )');
                }

            }

        });


        $('#messagegroup').keyup(function () {
            var str = this.value;
            var msgResponse = isDoubleByte(str);
            var charsgroup = this.value.length;

            if (msgResponse == false) {
                $("#customRadio3").prop("checked", true);
                // console.log(chars);
                if (charsgroup <= 160) {
                    messagesgroup = Math.ceil(charsgroup / 160),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((1530 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 160 Char./SMS )');
                } else {
                    messagesgroup = Math.ceil(charsgroup / 153),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((1530 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text(' ( 153 Char./SMS ) ');
                }
            } else {
                $("#customRadio4").prop("checked", true);
                if (charsgroup <= 70) {
                    messagesgroup = Math.ceil(charsgroup / 70),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((670 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 70 Char./SMS )');
                } else {
                    messagesgroup = Math.ceil(charsgroup / 68),
                        $lengthgroup.text(charsgroup + ' characters');
                    $remaininggroup.text((670 - charsgroup) + ' characters left | ');
                    $messagesgroup.text(messagesgroup + ' SMS');
                    $smslengroup.text('( 68 Char./SMS )');
                }

            }

        });


    });


    function isDoubleByte(str) {
        for (var i = 0, n = str.length; i < n; i++) {
            // console.log(i)
            //if (str.charCodeAt( i ) > 255 && str.charCodeAt( i )!== 8364 )
            if (str.charCodeAt(i) > 255 ||
                str.charCodeAt(i) == 91 ||
                str.charCodeAt(i) == 92 ||
                str.charCodeAt(i) == 93 ||
                str.charCodeAt(i) == 94 ||
                str.charCodeAt(i) == 123 ||
                str.charCodeAt(i) == 124 ||
                str.charCodeAt(i) == 125 ||
                str.charCodeAt(i) == 126
            ) {
                return true;
            }
        }
        return false;
    }

</script>

    <script>
        $(document).ready(function() {

            function formatState(state) {
                if (!state.id) {
                    return state.text;
                }

                var $state = $(
                    '<span><input type="checkbox" class="select2-checkbox" /> ' + state.text + '</span>'
                );

                // Ensure the checkbox is checked if the item is selected
                if ($(state.element).prop('selected')) {
                    $state.find('input').prop('checked', true);
                }

                return $state;
            }

            $('#mobile_numbers').select2({
                placeholder: "Select mobile numbers",
                templateResult: formatState,
                templateSelection: function(selection) {
                    return selection.text;
                },
                closeOnSelect: false
            });

            $('#mobile_numbers').on('select2:select select2:unselect', function(e) {
                // Force the Select2 to redraw its options
                $(this).data('select2').trigger('change');
            });

            $('#mobile_numbers').on('select2:opening select2:closing', function(event) {
                var $searchfield = $(this).parent().find('.select2-search__field');
                $searchfield.prop('disabled', true);
            });

            $('#mobile_numbers').on('change', function() {
                var selectedValues = $(this).val();
                $(this).find('option').each(function() {
                    var optionValue = $(this).val();
                    var $option = $(this);
                    if(optionValue!=0)
                        if (selectedValues.includes(optionValue)) {
                            $option.prop('selected', true);
                        } else {
                            $option.prop('selected', false);
                        }
                });
            });

            // Custom event handler to toggle checkbox when clicking on the item
            $('#mobile_numbers').on('select2:selecting', function(e) {
                var $checkbox = $(e.params.args.data.element).find('input[type="checkbox"]');
                $checkbox.prop('checked', !$checkbox.prop('checked'));
            });

            // Additional event handler for clicks outside of the checkbox
            $(document).on('click', '.select2-results__option', function(e) {
                var $checkbox = $(this).find('input[type="checkbox"]');
                if ($(e.target).is('input[type="checkbox"]')) {
                    return;
                }
                $checkbox.prop('checked', !$checkbox.prop('checked'));
            });

            var $remaining = $('#remaining'),
                $length = $('#length'),
                $smslen = $('#smslen'),
                $messages = $remaining.next();

            $('#message').keyup(function() {
                var str = this.value;
                var msgResponse = isDoubleByte(str);
                var chars = this.value.length;

                if (msgResponse == false) {
                    $("#customRadio1").prop("checked", true);
                    console.log(chars);
                    if (chars <= 160) {
                        messages = Math.ceil(chars / 160),
                        $length.text(chars + ' characters');
                        $remaining.text((1530 - chars) + ' characters left | ');
                        $messages.text(messages + ' SMS');
                        $smslen.text('( 160 Char./SMS )');
                    } else {
                        messages = Math.ceil(chars / 153),
                        $length.text(chars + ' characters');
                        $remaining.text((1530 - chars) + ' characters left | ');
                        $messages.text(messages + ' SMS');
                        $smslen.text(' ( 153 Char./SMS ) ');
                    }
                } else {
                    $("#customRadio2").prop("checked", true);
                    if (chars <= 70) {
                        messages = Math.ceil(chars / 70),
                        $length.text(chars + ' characters');
                        $remaining.text((670 - chars) + ' characters left | ');
                        $messages.text(messages + ' SMS');
                        $smslen.text('( 70 Char./SMS )');
                    } else {
                        messages = Math.ceil(chars / 67),
                        $length.text(chars + ' characters');
                        $remaining.text((670 - chars) + ' characters left | ');
                        $messages.text(messages + ' SMS');
                        $smslen.text('( 67 Char./SMS )');
                    }

                }

            });

            $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){

            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                  
                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                           
                        // }
                    }
                
                    $('select.section_id').empty().append(option);
                });
            }
        }

        });


        function isDoubleByte(str) {
            for (var i = 0, n = str.length; i < n; i++) {
                if (str.charCodeAt(i) > 255 ||
                    str.charCodeAt(i) == 91 ||
                    str.charCodeAt(i) == 92 ||
                    str.charCodeAt(i) == 93 ||
                    str.charCodeAt(i) == 94 ||
                    str.charCodeAt(i) == 123 ||
                    str.charCodeAt(i) == 124 ||
                    str.charCodeAt(i) == 125 ||
                    str.charCodeAt(i) == 126
                ) {
                    return true;
                }
            }
            return false;
        }
    </script>

@endsection