@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="{{ route('date-wise-sms-reports.search-sms') }}">
                @csrf
                <div class="row">
                    <div class="col-md-2  col-6">
                        <input type="text" id="reportrange" name="date_range" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2 col-6">
                        <button class="btn btn-sm btn-info">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Daily Report</h6>
        <div class="m-0 float-right">
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @isset($smsList)
            <div class="table-responsive" >
                <table class="table dataTable" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Date</th>
                            <th>Status</th>
                            <th class="text-center">Total SMS</th>
                            <th>Cost</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $total_cost = 0;
                        @endphp
                        @foreach ($smsList as $sms)
                            @php
                                $total_cost += $sms->total_cost;
                            @endphp
                            <tr>
                                <td>{{ view_date_format($sms->send_date) }}</td>
                                <td>{{$sms->status}}</td>
                                <td class="text-center">{{$sms->total_sms}}</td>
                                <td>{{$sms->total_cost}}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <td></td>
                            <td></td>
                            <td>Total Cost</td>
                            <td>{{$total_cost}}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            @endisset
        </div>
    </div>
</div>
@endsection
