@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="{{ route('sms-reports.search-sms') }}">
                @csrf
                <div class="row">
                    <div class="col-md-2  col-6">
                        <input type="text" id="reportrange" name="date_range" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2 col-6">
                        <button class="btn btn-sm btn-info">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">SMS Reports</h6>
            <div class="m-0 float-right">
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                @isset($smsList)
                    <div class="table-responsive">
                        <table class="table dataTable" id="dataTable">
                            <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                {{--                                <th>Send From</th>--}}
                                <th>Date</th>
                                <th>Sent To</th>
                                <th>Receiver Name</th>
                                <th>Receiver Type</th>
                                <th>SMS Text</th>
                                <th>Status</th>
{{--                                <th>Cost</th>--}}
                            </tr>
                            </thead>
                            <tbody>
                            @php
                                $total_cost = 0;
                            @endphp
                            @foreach ($smsList as $sms)
                                @php
                                    $total_cost += $sms->sms_cost;
                                @endphp
                                <tr>
                                    <th class="text-center">{{$loop->iteration}}</th>
                                    {{--                                    <td>{{$sms->send_from}}</td>--}}
                                    <td>{{ view_date_format($sms->send_time) }}</td>
                                    <td>{{$sms->send_to}}</td>
                                    <td>{{$sms?->userInfo?->name ?? 'N/A'}}</td>
                                    <td>{{ucfirst($sms?->userInfo?->user_type ?? 'N/A')}}</td>
                                    <td>{{urldecode(Str::limit($sms->sms_text, 50))}}</td>
                                    <td>{{$sms->status}}</td>
{{--                                    <td>{{$sms->sms_cost}}</td>--}}
                                </tr>
                            @endforeach
                            </tbody>
{{--                            <tfoot>--}}
{{--                            <tr class="table-info">--}}
{{--                                <td></td>--}}
{{--                                <td colspan="6">Total Cost</td>--}}
{{--                                <td>{{$total_cost}}</td>--}}
{{--                            </tr>--}}
{{--                            </tfoot>--}}
                        </table>
                    </div>
                @endisset
            </div>
        </div>
    </div>
@endsection
