@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Student SMS List</h5> 
        @can('exam-result.publish-result.create')
        <a href="{{ route('student-sms.create') }}" class="btn btn-sm btn-primary">Send SMS</a>
        @endcan
    </div>
    <div class="card-body"> 
        <div class="table-responsive">
            @if ($studentSmsList)
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>Send From</th>
                            <th>Sent To</th>
                            <th>SMS</th>
                            <th>Cost</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $total_cost = 0;
                        @endphp
                        @foreach ($studentSmsList as $sms)
                            @php
                                $total_cost += $sms->sms_cost;
                            @endphp
                            <tr>
                                <td>{{$sms->send_from}}</td>
                                <td>{{$sms->send_to}}</td>
                                <td>{{urldecode($sms->sms_text)}}</td>
                                <td>{{$sms->sms_cost}}</td>
                                <td>{{$sms->status}}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <td colspan="3">Total Cost</td>
                            <td>{{$total_cost}}</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            @else
                <h3>No data found</h3>
            @endif

        </div>
    </div>
</div>


@endsection
