@extends('layouts.master')
@section('styles')
    <style type="text/css">
        .attendance_status {
            width: 34px !important;
            height: 34px !important;
            font-weight: bold !important;
            padding-top: 5px !important;
        }
    </style>
@endsection
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="{{ route('student_attendance.search') }}" class="row">
                @csrf
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Shift") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control student_class_id student_class" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
                </div>

                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
                </div>

                <x-group-selector
            name="group_id"
            label=""
            labelText="Group"
            col="form-group col-lg-2 col-md-4 col-sm-6"
            :student_class_id="(int) request()->input('student_class')"
            :required="(int) request()->input('student_class') >= 11"
            :selected="old('group_id') ?? request()->input('group_id')"
        />

                {{-- <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Group") }}
                </div> --}}
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <input type="date" class="form-control attendance_date" name="attendance_date"
                           value="{{$attendance_date ?? date("Y-m-d")}}" id="attendance_date" readonly required>
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <button type="submit" class="btn btn-info ">Search</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="row">
            <div class="col-md-12">
                <form method="POST" action="{{ route('student_attendance.store') }}">
                    @csrf
                    <div class="form-inline">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Roll</th>
                                    <th>Std. ID</th>
                                    <th>Student Name</th>
                                    <th>Action</th>
                                    <th>Note</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if (isset($students))
                                    @foreach($students as $key=>$student)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $student->class_roll }}</td>
                                            <td>{{ $student->student_id_no }}</td>
                                            <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                            <td>
                                                <input type="hidden" name="student_id[]" value="{{$student->id}}">
                                                <div class="form-check-inline">
                                                    <label class="form-check-label " for="radioP{{$student->id}}">
                                                        <input type="radio" class="form-check-input"
                                                               id="radioP{{$student->id}}"
                                                               name="attendance_status[{{$student->id}}]" value="P"
                                                               checked>Present
                                                    </label>
                                                </div>
                                                <div class="form-check-inline">
                                                    <label class="form-check-label" for="radioA{{$student->id}}">
                                                        <input
                                                            @if(isset($student->attendance->is_absent) && $student->attendance->is_absent == 1) checked
                                                            @endif type="radio" class="form-check-input"
                                                            id="radioA{{$student->id}}"
                                                            name="attendance_status[{{$student->id}}]" value="A">Absent
                                                    </label>
                                                </div>
                                                <div class="form-check-inline">
                                                    <label class="form-check-label" for="radioL{{$student->id}}">
                                                        <input
                                                            @if(isset($student->attendance->is_late) && $student->attendance->is_late == 1) checked
                                                            @endif type="radio" class="form-check-input"
                                                            id="radioL{{$student->id}}"
                                                            name="attendance_status[{{$student->id}}]" value="L">Late
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" style="max-width: 100px;" maxlength="50"
                                                       name="note[{{$student->id}}]"
                                                       value="@if(!empty($student->attendance->note)) {{$student->attendance->note}} @endif">

                                                <input type="hidden" name="student_class_id[{{$student->id}}]"
                                                       value="@if(!empty($student_class_id)) {{$student_class_id}} @endif">
                                                <input type="hidden" name="shift_id"
                                                       value="@if(!empty($shift_id)) {{$shift_id}} @endif">
                                                <input type="hidden" name="section_id"
                                                       value="@if(!empty($section_id)) {{$section_id}} @endif">
                                                <input type="hidden" class="form-control attendance_date"
                                                       name="attendance_date"
                                                       value="{{$attendance_date ?? date("Y-m-d")}}"
                                                       id="attendance_date" readonly required>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6" class="text-center"> No data available in table</td>
                                    </tr>
                                @endif
                                </tbody>
                                @if (isset($students))
                                    <tfoot>
                                    <tr>
                                        <td colspan="6">
                                            <button type="submit" class="btn btn-info float-right"
                                                    style="padding:10px;">Save Attendance
                                            </button>
                                        </td>
                                    </tr>
                                    </tfoot>
                                @endif
                            </table>

                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        const shift_id = "{{$shift_id}}";
        const studentAttendance = (event, student_id) => {
            event.preventDefault();
            if (student_id) {
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("{{ route('student_attendance.store') }}", {
                    _token: csrfToken,
                    student_id: student_id,
                    shift_id: shift_id
                }, function (response) {
                    console.log(response)
                    if (response.success) {
                        const icon = response.success ? '<i style="font-size: 1.5rem;color: green;" class="fas fa-check-circle"></i>' : '<i style="font-size: 1.5rem;color: red;" class="fas fa-exclamation-circle"></i>';
                        $(`#icon-${student_id}`).html(icon);
                        $(buttonId).prop('disabled', true);
                    }
                });
            }
        }

        $('.student_class').on('change', function () {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {student_class_id: student_class_id}, function (response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for (let i = 0; i < sections.length; i++) {
                        // if(sections[i].student_class_id == student_class_id){
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name + '</option>';
                        }

                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }


    </script>
@endsection
