@extends('layouts.master')

@php

        

        // $attendance_status = $request->attendance_status33;

        // $attendance_data = [
        //     'student_id' => $request->student_id,
        //     'branch_id' => 1,
        //     'shift_id' => $request->shift_id,
        //     'punch_date' => date('Y-m-d'),
        //     'day_status' => $attendance_status,
        //     'created_by' => auth()->user()->id,
        // ];

        // if($attendance_status=="P"){
        //     $attendance_data['is_present'] = 1;
        //     $attendance_data['is_absent'] = 0;
        //     $attendance_data['is_late'] = 0;
        //     $attendance_data['is_holiday'] = 0;
        //     $attendance_data['is_half_day'] = 0;
        // }elseif($attendance_status=="A"){
        //     $attendance_data['is_present'] = 0;
        //     $attendance_data['is_absent'] = 1;
        //     $attendance_data['is_late'] = 0;
        //     $attendance_data['is_holiday'] = 0;
        //     $attendance_data['is_half_day'] = 0;
        // }elseif($attendance_status=="L"){
        //     $attendance_data['is_present'] = 0;
        //     $attendance_data['is_absent'] = 0;
        //     $attendance_data['is_late'] = 1;
        //     $attendance_data['is_holiday'] = 0;
        //     $attendance_data['is_half_day'] = 0;
        // }elseif($attendance_status=="HD"){
        //     $attendance_data['is_present'] = 0;
        //     $attendance_data['is_absent'] = 0;
        //     $attendance_data['is_late'] = 0;
        //     $attendance_data['is_holiday'] = 1;
        //     $attendance_data['is_half_day'] = 0;
        // }elseif($attendance_status=="Half"){
        //     $attendance_data['is_present'] = 0;
        //     $attendance_data['is_absent'] = 0;
        //     $attendance_data['is_late'] = 0;
        //     $attendance_data['is_holiday'] = 0;
        //     $attendance_data['is_half_day'] = 1;
        // }


        // $checkAttendance = StudentAttendance::where('student_id',$request->student_id)->where('punch_date', date('Y-m-d'))->first();

        // if(!empty($checkAttendance)){
        //     StudentAttendance::where('student_id',$request->student_id)->where('punch_date', date('Y-m-d'))->update($attendance_data);
        //     $data = StudentAttendance::where('student_id',$request->student_id)->where('punch_date', date('Y-m-d'))->first();
        // }else{
        //     $data = StudentAttendance::create($attendance_data);
        // }

@endphp

@section('content')
<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('student_attendance.search') }}" class="row">
            @csrf

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Shift") }}
            </div>
            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Group") }}
            </div>
            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
            </div>

            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                <input type="date" class="form-control attendance_date" name="attendance_date" value="{{$attendance_date ?? date("Y-m-d")}}" id="attendance_date" readonly required>
            </div>
            <div class="form-group col-lg-2 col-md-4 col-sm-6">
                <button type="submit" class="btn btn-info ">Search</button>
            </div>
        </form>
    </div>
</div>
@if (isset($students))

    <div class="card mt-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <form method="POST" action="{{ route('marks.store') }}" class="form-inline">
                        @csrf
                        <div class="table-responsive">

                            <table class="table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Student ID</th>
                                        <th>Roll</th>
                                        <th>Student Name</th>
                                        <th>Action</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($students as $student)
                                        <tr>
                                            <td>{{ $student->student_id_no }}</td>
                                            <td>{{ $student->class_roll }}</td>
                                            <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                            <td>
                                                <button id="attendance-btn-{{$student->id}}" class="btn btn-sm btn-info" onclick="studentAttendance(event, {{$student->id}}, 'P')" >Present</button>
                                                <button id="attendance-btn-{{$student->id}}" class="btn btn-sm btn-primary" onclick="studentAttendance(event, {{$student->id}}, 'A')" >Absent</button>
                                            </td>
                                            <td id="icon-{{$student->id}}">
                                                @if (isset($student->attendance->is_present) && $student->attendance->is_present == 1)
                                                    <span class="d-inline-block rounded-circle bg-success text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">P</span>
                                                @elseif (isset($student->attendance->is_absent) && $student->attendance->is_absent == 1)
                                                    <span class="d-inline-block rounded-circle bg-warning text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">A</span>
                                                @else
                                                    <i style="font-size: 1.7rem;color: red; font-weight: bold;" class="fas fa-exclamation-circle"></i>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

@endif
@stop



@section('scripts')
    <script>
        const shift_id = "{{$shift_id}}";
        const studentAttendance = (event, student_id, attendance_status) => {
            event.preventDefault();
            if(student_id){
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("{{ route('student_attendance.store') }}", {
                    _token: csrfToken,
                    student_id: student_id,
                    attendance_status: attendance_status,
                    shift_id: shift_id
                }, function(response) {
                    if (response.success) {
                        let icon = '';
                        console.log(response)
                        if(response.data.is_present == 1){
                            icon = `<span class="d-inline-block rounded-circle bg-success text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">P</span>`;
                        }else if(response.data.is_absent == 1){
                            icon = `<span class="d-inline-block rounded-circle bg-warning text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">A</span>`;
                        }
                        $(`#icon-${student_id}`).html(icon);

                        toastr.success(response.message, 'Success');

                    }
                });
            }
        }

        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }

    </script>
@endsection













=================================report.blade.php================
@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('student_attendance.attendance_report') }}" class="row">
            @csrf
            <div class="col-md-6">
                <div class="row">
                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                        {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Select Shift") }}
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Select Group") }}
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id"', $student_class_id, "Select Class") }}
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" ', $section_id, 'Section') }}
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <select name="year" class="form-control year">
                            @foreach($academicYears as $a_year)
                                @if ($a_year->year == $year)
                                    <option value="{{$a_year->year}}" selected>{{ $a_year->year }}</option>
                                @else
                                    <option value="{{$a_year->year}}">{{ $a_year->year }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">   
                        {{ generateDropdown($months, 'class="form-control month" id="month" name="month"', $month, "Select Month") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


@if (isset($students))

    <div class="card mt-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <form method="POST" action="{{ route('marks.store') }}" class="form-inline">
                        @csrf
                        <div class="table-responsive">

                            <table class="table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Roll</th>
                                        <th>Name</th>
                                        @for ($i=1; $i<=$totalDays; $i++)
                                            <th>{{$i}}</th>
                                        @endfor
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($students as $student)
                                        
                                        <tr>
                                            <td>{{ $student->class_roll }}</td>
                                            <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                            @php
                                                $currentDate = \Carbon\Carbon::parse($from_date);
                                            @endphp
                                            @for ($day = 1; $day <= $totalDays; $day++)
                                                <td>
                                                    @php
                                                        $attendance = $student->attendances->firstWhere('punch_date', $currentDate->toDateString());
                                                    @endphp
                                                    @if ($attendance)
                                                        @if ($attendance->day_status=='A')
                                                        <span class="d-inline-block rounded-circle bg-danger text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">{{$attendance->day_status}}</span>
                                                        @else

                                                        <span class="d-inline-block rounded-circle bg-success text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">{{$attendance->day_status}}</span>
                                                        @endif
                                                    @else
                                                        -
                                                    @endif
                                                    @php
                                                        $currentDate = $currentDate->addDays(1);
                                                    @endphp
                                                </td>
                                            @endfor
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>
                
            </div>
        </div>
    </div>
    
@endif
@stop

@section('scripts')
    <script>
        const shift_id = "{{$shift_id}}";
        const studentAttendance = (event,student_id) => {
            event.preventDefault();
            if(student_id){
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("{{ route('student_attendance.store') }}", {
                    _token: csrfToken,
                    student_id: student_id,
                    shift_id: shift_id
                }, function(response) {
                    console.log(response)
                    if (response.success) {
                        const icon = response.success ? '<i style="font-size: 1.5rem;color: green;" class="fas fa-check-circle"></i>' : '<i style="font-size: 1.5rem;color: red;" class="fas fa-exclamation-circle"></i>';
                        $(`#icon-${student_id}`).html(icon);
                        $(buttonId).prop('disabled', true);
                    }
                });
            }
        }

        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }

        
    </script>
@endsection






==============================

<table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Total Date</th>
                                    <th>Total Present</th>
                                    <th>Total Absent</th>
                                    <th>Total Late</th>
                                    <th>Total Holiday</th>
                                    <th>Total Half Day</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($dates as $date)
                                <tr>
                                    <td>{{ $date->punch_date }}</td>
                                    <td>{{ App\Models\Attendance\StudentAttendance::where([['punch_date', $date->punch_date],['day_status','P']])->count(); }}</td>
                                    <td>{{ App\Models\Attendance\StudentAttendance::where([['punch_date', $date->punch_date],['day_status','A']])->count(); }}</td>
                                    <td>{{ App\Models\Attendance\StudentAttendance::where([['punch_date', $date->punch_date],['day_status','L']])->count(); }}</td>
                                    <td>{{ App\Models\Attendance\StudentAttendance::where([['punch_date', $date->punch_date],['day_status','H']])->count(); }}</td>
                                    <td>{{ App\Models\Attendance\StudentAttendance::where([['punch_date', $date->punch_date],['day_status','HDL']])->count(); }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>