@extends('layouts.master')
@section('styles')
<style type="text/css">
    .attendance_status{
        width: 34px !important;
        height: 34px !important;
        font-weight: bold !important;
        padding-top: 5px !important;
    }
</style>
@endsection
@section('content')
<div class="card">
    <div class="card-body card__head">
        <form method="get" action="{{ route('student_attendance.report.date_to_date.search') }}" class="row">
            <div class="form-group col-lg-3 col-md-4 col-sm-6">
                {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
            </div>
            <div class="form-group col-lg-3 col-md-4 col-sm-6">
                {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" required', $shift_id, "Shift") }}
            </div>
            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                <input type="text" id="reportrange" name="date" class="form-control">
            </div>
            <div class="form-group col-lg-3 col-md-4 col-sm-6">
                <button type="submit" class="btn btn-info">Search</button>
            </div>
        </form>
    </div>
</div>

@if (isset($attendances))
    <div class="card mt-4" id="print-layout">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Student Attendance Report : <small>@if(!empty($from)) {{$from}} @endif TO @if(!empty($to)) {{$to}} @endif</small></h6>
            <div class="m-0 float-right ">
                @if (isset($attendances))
                    <form method="get" action="{{ route('student_attendance.report.date_to_date.search') }}">
                        <input type="hidden" id="student_class_id" name="student_class_id" value="{{$student_class_id}}" class="form-control">
                        <input type="hidden" id="shift_id" name="shift_id" value="{{$shift_id}}" class="form-control">
                        <input type="hidden" id="reportrange" name="date" value="{{$daterange}}" class="form-control">
                        <button type="submit" class="btn btn-secondary btn__export" value="export" name="export" title="Download To Excel File"><i class="fas fa-file-excel"></i></button>
                        <button type="submit" class="btn btn-secondary btn__export" value="pdf" name="pdf" title="Download To PDF File"><i class="fas fa-file-pdf"></i></button>
                        
                    <button type="submit" class="btn btn-secondary btn__export" onclick="printCertificate()" value="pdf" name="pdf" title="Print"><i class="fas fa-print"></i></button>
                    </form>
                @endif
            </div>
        </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>Student ID</th>
                                    <th>Roll</th>
                                    <th>Name</th>
                                    <th>Total Present</th>
                                    <th>Total Absent</th>
                                    <th>Total Late</th>
                                    <th>Total Days</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($attendances as $attendance)
                                    <tr>
                                        <td>{{ $attendance['studentInfo']['student_id_no'] }}</td>
                                        <td>{{ $attendance['studentInfo']['class_roll'] }}</td>
                                        <td>{{ $attendance['studentInfo']['first_name'] }} {{ $attendance['studentInfo']['last_name'] }}</td>
                                        <td>{{ $attendance->totoal_present}}</td>
                                        <td>{{ $attendance->totoal_absent}}</td>
                                        <td>{{ $attendance->totoal_late}}</td>
                                        <td>{{ $attendance->punch_date}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
    </div>
@else
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Student Attendance Report</h6>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Roll</th>
                            <th>Name</th>
                            <th>Total Present</th>
                            <th>Total Absent</th>
                            <th>Total Late</th>
                            <th>Total Holiday</th>
                            <th>Total Half Day</th>
                            <th>Total Days</th>
                        </tr>
                    </thead>
                    <tbody>
                       <tr>
                        <td colspan="9" class="text-center">No data available in table</td>
                       </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
@endif
@stop

@section('scripts')
<script type="text/javascript">
$(function() {
    var start = moment().subtract(29, 'days');
    var end = moment();
    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    }
    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);
    cb(start, end);
});

function printCertificate() {
     var printContents = document.getElementById("print-layout").innerHTML;
     var originalContents = document.body.innerHTML;
     document.body.innerHTML = printContents;
     window.print();
     document.body.innerHTML = originalContents;
}

</script>
@endsection