@extends('layouts.master')
@section('styles')
    <style type="text/css">

    </style>
@endsection
@section('content')
    <div class="mt-4 std__attn pb-5">
        <div class="attn__header text-center mb-2">
            <h4 class="mb-1">Today's Attendance</h4>
            <h4><span><?php
                    echo date('l, jS F Y');?>
                </span>
            </h4>
           <h4>My Class: <b>{{$student_class_name ?? ''}}, Section: {{$section_name ?? ''}}</b></h4>
        </div>

        <div class="std__attn__body">
            <form method="POST" action="{{ route('student_attendance.store') }}">
                @csrf
                <div class="form-inline">
                    @if (isset($students))
                        <div class="row">
                            @foreach($students as $key=>$student)
                                <div class="col-lg-6 col-xl-4 col-xxl-3 col-12 std__single">
                                    <div class="std__card">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div class="std__info d-flex align-items-center">
                                                        <img src="/uploads/student/graduated_student.png"
                                                             alt="{{ $studentInfo->name ?? 'N/A'}}" height="50">
                                                        <div class="info">
                                                            <p class="mb-1">Roll: {{ $student->class_roll }}</p>
                                                            <p class="mb-1"><b>{{ $student->first_name }} {{ $student->last_name }}</b></p>
                                                            <p class="mb-1">Call: <a
                                                                    href="tel:{{ $student->guardian_mobile }}">
                                                                    <svg
                                                                        xmlns="http://www.w3.org/2000/svg"
                                                                        width="32"
                                                                        height="32"
                                                                        viewBox="0 0 24 24"
                                                                        fill="none"
                                                                        stroke="#000000"
                                                                        stroke-width="1"
                                                                        stroke-linecap="round"
                                                                        stroke-linejoin="round"
                                                                    >
                                                                        <path
                                                                            d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2"/>
                                                                        <path d="M15 7a2 2 0 0 1 2 2"/>
                                                                        <path d="M15 3a6 6 0 0 1 6 6"/>
                                                                    </svg>
                                                                </a></p>
                                                        </div>
                                                    </div>
                                                    <div class="std__action">
                                                        <input type="hidden" name="student_id[]"
                                                               value="{{$student->id}}">
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label "
                                                                   for="radioP{{$student->id}}">
                                                                <input type="radio" class="form-check-input"
                                                                       id="radioP{{$student->id}}"
                                                                       name="attendance_status[{{$student->id}}]"
                                                                       value="P"
                                                                       checked>Present
                                                            </label>
                                                        </div>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label"
                                                                   for="radioA{{$student->id}}">
                                                                <input
                                                                    @if(isset($student->attendance->is_absent) && $student->attendance->is_absent == 1) checked
                                                                    @endif type="radio" class="form-check-input"
                                                                    id="radioA{{$student->id}}"
                                                                    name="attendance_status[{{$student->id}}]"
                                                                    value="A">Absent
                                                            </label>
                                                        </div>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label"
                                                                   for="radioL{{$student->id}}">
                                                                <input
                                                                    @if(isset($student->attendance->is_late) && $student->attendance->is_late == 1) checked
                                                                    @endif type="radio" class="form-check-input"
                                                                    id="radioL{{$student->id}}"
                                                                    name="attendance_status[{{$student->id}}]"
                                                                    value="L">Late
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="attn__note">
                                    {{--                                    <input type="text" style="max-width: 100px;" maxlength="50"--}}
                                    {{--                                           name="note[{{$student->id}}]"--}}
                                    {{--                                           value="@if(!empty($student->attendance->note)) {{$student->attendance->note}} @endif">--}}

                                    <input type="hidden" name="student_class_id[{{$student->id}}]"
                                           value="@if(!empty($student_class_id)) {{$student_class_id}} @endif">
                                    <input type="hidden" name="shift_id"
                                           value="@if(!empty($shift_id)) {{$shift_id}} @endif">
                                    <input type="hidden" name="section_id"
                                           value="@if(!empty($section_id)) {{$section_id}} @endif">
                                    <input type="hidden" class="form-control attendance_date"
                                           name="attendance_date"
                                           value="{{$attendance_date ?? date("Y-m-d")}}"
                                           id="attendance_date" readonly required>
                                </div>
                            @endforeach

                        </div>
                    @else
                    <tr>
                        <td colspan="6" class="text-center"> No data available in table</td>
                    </tr>
                    @endif
                        @if (isset($students) && !empty($students))
                            
                            <div class="text-center">
                                <button type="submit" class="btn btn-submit att__btn mt-3">Submit
                                </button>
                            </div>
                        @endif

                </div>
            </form>
        </div>
    </div>
@endsection

