<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Student Attendance {{ $from ?? '' }} TO {{ $to ?? '' }}</title>
    <style>
    .center{
        text-align: center;
    }
    .left{
        text-align: left;
    }
    .header {
        padding: 10px;
        border-bottom: 1px solid #ccc;
/*        background: #10af95;*/
        text-align: center;
    }
    .header img{
        width: auto;
        height: 50px;
        padding: .25rem !important;
        filter: invert(1);
        opacity: .7;
    }
    .header .institute-name{
        padding: 0;
        margin: 0;
    } 
    .header p{
        margin: 0;
        padding: 0;
    }
    .main-table{
        width: 100%;
    }
    .main-table thead{
/*        background-color:#f39700;*/
        background-color:#eaecf4;
        color: black;
        width: 100%;
    }
    .main-table thead tr th{
        text-transform: capitalize;
    }
    table.main-table {
       border-collapse: collapse;
    }
    table.main-table td,  table.main-table th {
        border: 1px solid #e3e6f0;
        font-size: 14px;
    }
    table.main-table thead tr th{
        margin-bottom: 5px;
        font-size: 14px;
    }


</style>
</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p><strong>Class:</strong> {{ $className ?? '' }} <strong>Shift:</strong> {{ $shiftName ?? '' }} </p>   
            <p><strong>Date:</strong> {{ $from ?? '' }} TO {{ $to ?? '' }}</p>
        </div>
        <table class="main-table">
            <thead>
                <tr>
                    <th class="center">Std. ID</th>
                    <th style="text-align: center;width: 40px;">Roll</th>
                    <th style="padding-left:5px;" class="left">Name</th>
                    <th class="center">Present</th>
                    <th class="center">Absent</th>
                    <th class="center">Late</th>
                    <th class="center">Days</th>
                    @if(!empty($extra_col))
                        @php $extra_col_array = explode(',', $extra_col); @endphp
                        @foreach($extra_col_array as $col)
                            <th class="left">{{ Str::replace('_',' ',$col)}}</th>
                        @endforeach
                    
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($attendances as $attendance)
                    <tr>
                        <td class="center">{{ $attendance['studentInfo']['student_id_no'] }}</td>
                        <td style="text-align: center;width: 40px;">{{ $attendance['studentInfo']['class_roll'] }}</td>
                        <td style="padding-left:5px;">{{ $attendance['studentInfo']['first_name'] }} {{ $attendance['studentInfo']['last_name'] }}</td>
                        <td class="center">{{ $attendance->totoal_present}}</td>
                        <td class="center">{{ $attendance->totoal_absent}}</td>
                        <td class="center">{{ $attendance->totoal_late}}</td>
                        <td class="center">{{ $attendance->punch_date}}</td>
                        @if(!empty($extra_col))
                            @foreach($extra_col_array as $col)
                            <td class="left">{{ $attendance['studentInfo'][$col] }}</td>
                            @endforeach
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>   
</body>
</html>