@extends('layouts.master')
@section('styles')
<style type="text/css">
    .attendance_status{
        width: 34px !important;
        height: 34px !important;
        font-weight: bold !important;
        padding-top: 5px !important;
    }
    .table .thead-light th:first-child, .card .table td:first-child{
        min-width: 25px !important;
    }
    .card .table td, .card .table th{
        padding-right: 1px !important;
        padding-left: 1px !important;
        text-align: center;
        min-width: 25px;
        /* height: auto; */
    }
</style>
@endsection
@section('content')
<div class="card">
    <div class="card-body card__head">
        <form method="POST" action="{{ route('student_attendance.attendance_report') }}" class="row">
            @csrf
            <div class="col-md-6">
                <div class="row">
                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                        {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Select Shift") }}
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class_id student_class" id="student_class" name="student_class_id"', $student_class_id, "Select Class") }}
                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section') }}
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <x-group-selector
            name="group_id"
            label=""
            labelText="Group"
            col="form-group col-lg-3 col-md-6 col-sm-6"
            :student_class_id="(int) request()->input('student_class')"
            :required="(int) request()->input('student_class') >= 11"
            :selected="old('group_id') ?? request()->input('group_id')"
        />
                    {{-- <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', $group_id, "Select Group") }}
                    </div> --}}
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <select name="year" class="form-control year">
                            @foreach($academicYears as $a_year)
                                @if ($a_year->year == $year)
                                    <option value="{{$a_year->year}}" selected>{{ $a_year->year }}</option>
                                @else
                                    <option value="{{$a_year->year}}">{{ $a_year->year }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">   
                        {{ generateDropdown(config('months'), 'class="form-control month" id="month" name="month"', $month, "Select Month") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@if (isset($students))
    <div class="card mt-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Roll</th>
                                    <th>Name</th>
                                    @for ($i=1; $i<=$totalDays; $i++)
                                        <th>{{$i}}</th>
                                    @endfor
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($students as $key=>$student)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $student->class_roll }}</td>
                                        <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                        @php
                                            $currentDate = \Carbon\Carbon::parse($from_date);
                                        @endphp
                                        @for ($day = 1; $day <= $totalDays; $day++)
                                            <td>
                                                @php
                                                    $attendance = $student->attendances->firstWhere('punch_date', $currentDate->toDateString());
                                                @endphp
                                                @if ($attendance)
                                                    @if ($attendance->day_status=='A')
                                                    <span class="d-inline-block rounded-circle bg-danger text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">{{$attendance->day_status}}</span>
                                                    @else
                                                    <span class="d-inline-block rounded-circle bg-success text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;">{{$attendance->day_status}}</span>
                                                    @endif
                                                @else
                                                    -
                                                @endif
                                                @php
                                                    $currentDate = $currentDate->addDays(1);
                                                @endphp
                                            </td>
                                        @endfor
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@stop
@section('scripts')
    <script>
        const shift_id = "{{$shift_id}}";
        const studentAttendance = (event,student_id) => {
            event.preventDefault();
            if(student_id){
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("{{ route('student_attendance.store') }}", {
                    _token: csrfToken,
                    student_id: student_id,
                    shift_id: shift_id
                }, function(response) {
                    console.log(response)
                    if (response.success) {
                        const icon = response.success ? '<i style="font-size: 1.5rem;color: green;" class="fas fa-check-circle"></i>' : '<i style="font-size: 1.5rem;color: red;" class="fas fa-exclamation-circle"></i>';
                        $(`#icon-${student_id}`).html(icon);
                        $(buttonId).prop('disabled', true);
                    }
                });
            }
        }
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });
        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
        if(student_class_id!=''){
            getSection(student_class_id);
        }
        function getSection(student_class_id){
            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">Select Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
@endsection