@extends('layouts.master')
@section('content')
<style>
/*    ///new*/
    .id-card {
        height: 450px;
        margin: 10px;
        padding: 10px;
        background-color: transparent;
        border-radius: 10px;
        box-shadow: 0 0 10px rgb(0 0 0 / 15%);
    }
    .id-card-header {
/*        background-color: #f0f0f0;*/
        padding: 10px;
/*        border-bottom: 1px solid #ccc;*/
        background: #10af95
        text-align: center;
    }
    .id-card-header img{
        width: 100%;
        height: auto !important;
        padding: .25rem !important;
        background: #10af95
    }
    .id-card-body {
        padding: 10px;
    }
    .id-card-body .student-image {
        text-align: center;
        margin-bottom: 5px;
    }
    .id-card-body .student-image img{
        width: 80px;
        height: 80px;
        border: 2px solid #ffc94ea6;
        border-radius: 0 !important;
        padding: 10px;
        margin-bottom:10px;
    }
    .id-card-body .student-info {
        padding: 0;
    }
    
    .id-card-text {
        font-size: 14px;
    }
    .id-card-title {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 0px;
    }
    .id-card-footer {
        padding: 10px;
        border-top: 6px solid #ffc94ea6;
    }
    

</style>
<div class="card">
    <div class="card-body card__head">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab', 'search') === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">Search By ID</a>
            </li>
            <li class="nav-item">
                <a class="nav-link {{ request()->query('tab') === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">Search by Class</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div id="search-tab" class="tab-pane {{ request()->query('tab', 'search') === 'search' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('student.id-card.index') }}" class="row">
                    <input type="hidden" name="tab" value="search">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        @component('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div id="filter-tab" class="tab-pane fade {{ request()->query('tab') === 'filter' ? 'show active' : '' }}"><br>
                <form method="GET" action="{{ route('student.id-card.index') }}" class="row">
                    <input type="hidden" name="tab" value="filter">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@if ($students) 
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Student List
            @if ($students)
                (Total Students : {{ $students ? $students->count() : 'N/A' }})
            @endif</h6>
        <div class="m-0 float-right">
            <form method="GET" action="{{ route('studentIdCardDownload') }}" class="row" target="_blank">
            <div class="d-none">
                <div class="form-group mb-0">
                    @component('components.search_student', [
                        'student_name' => $student_name ?? '',
                        'student_id_no' => request()->student_id_no ?? '',
                        'required' => '',
                    ])
                    @endcomponent
                </div>
            </div>
            <div class="d-none">
                {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
            </div>
            <div class="d-none">
                {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
            </div>
            <div class="d-none">
                {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class") }}
            </div>

            <div class="d-none">
                {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
            </div>

            @if(!empty($students))
            <button type="submit" class="btn btn-sm btn-primary">Download</button>
            @endif
        </form>

        </div>
    </div>

    <div class="card-body">
        
        <div class="row">
            @foreach($students as $student)
                @php
                    $student_image = $student->profile_image ? $student->profile_image : 'uploads/student/graduated_student.png';
                @endphp
                <div class="col-md-4">
                    <div class="id-card">
                        
                        <div class="id-card-header">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    @php
                                        $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : '/default/default.png';
                                    @endphp
                                    <img src="{{asset($logo_path)}}" style="background: #10af95;height:auto;width:70px;" class=" p-1">
                                    {{-- <img src="https://via.placeholder.com/50" alt="School Logo" > --}}
                                </div>
                                {{-- <div class="col-md-10">
                                    <h5 class="id-card-title">
                                        <span class="school-name-first-word">{{ explode(' ',get_setting_value(Settings::SCHOOL_NAME))[0] }}</span>
                                        <br>
                                        <span class="school-name-other-text">{{removeFirstWord(get_setting_value(Settings::SCHOOL_NAME))}}</span>
                                    </h5>
                                </div> --}}
                            </div>
                        </div>
                        <div class="id-card-body">
                            <div class="student-image">
                                <img src="{{ asset($student_image) }}" alt ="Student Image" class="img-fluid rounded-circle" style="width: 80px; height: 80px;">
                            </div>
                            <div class="student-info">
                                <h5 class="id-card-title">{{"$student->first_name $student->last_name"}}</h5>
                                <p class="id-card-text">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <strong>Student ID:</strong> {{ $student->student_id_no ?? "" }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Roll:</strong> {{ $student->class_roll ?? "" }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Class:</strong> {{ $student->studentClass->class_name ?? "" }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Shift:</strong> {{ $student->shift->shift_name ?? "" }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Section:</strong> {{ $student->section->section_name ?? "" }}
                                        </div>
                                        <div class="col-md-6">
                                            <strong>DOB:</strong> {{ $student->date_of_birth ?? "" }}
                                        </div>
                                        
                                    </div>
                                </p>
                            </div>
                            <img src="{{ asset('/signature/principal.jpg') }}" alt="" style="width: 100px; height: 30px;">
                            <p class="id-card-text">Principal's Signature</p>
                        </div>
                        <div class="id-card-footer">
                           
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
 
    </div>
</div>
@endif
@endsection