@extends('layouts.master')

@section('content')

<div class="card">

    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Import Student Data</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-primary" href="{{ asset('uploads/excel_demo_file/Student_Info.xlsx') }}" download="">Download Demo File</a>
        </div>
    </div>
    <div class="card-body m-3">
        <form action="{{ route('import_student.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
        
            <div class="row mt-3 justify-content-start">
                <div class="col-md-auto">
                    <div class="form-group">
                        <div class="custom-file">
                            <input type="file" name="file" class="custom-file-input" id="customFile" accept=".xlsx, .xls, .csv">
                            <label class="custom-file-label" for="customFile" id="customFileLabel">Choose file</label>
                        </div>
                    </div>
                </div>
                <div class="col-md-auto">
                    <div class="form-group">
                        <button class="btn btn-primary">Save</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    // JavaScript to update the label text with the selected file name
    document.getElementById('customFile').addEventListener('change', function (e) {
        var fileName = e.target.files[0].name;
        var label = document.getElementById('customFileLabel');
        label.innerText = fileName;
    });
</script>
@endsection