<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Student ID Card</title>
    <style>
    .id-card {
        height: 450px;
        margin: 10px;
        padding: 10px;
        background-color: transparent;
        border-radius: 10px;
        box-shadow: 0 0 10px rgb(0 0 0 / 15%);
    }
    .id-card-header {
        background-color: #f0f0f0;
        padding: 10px;
        border-bottom: 1px solid #ccc;
        background: #10af95
        text-align: center;
    }
    .id-card-header img{
        width:70px !important;
        height: auto !important;
        padding: .25rem !important;
        background: #10af95
    }
    .id-card-body {
        padding: 10px;
    }
    .id-card-body .student-image {
        text-align: center;
        margin-bottom: 5px;
    }
    .id-card-body .student-image img{
        width: 70px;
        height: 70px;
        border: 2px solid #ffc94ea6;
        border-radius: 0 !important;
        padding: 10px;
        margin-bottom:10px;
    }
    .id-card-body .student-info {
        padding: 0;
    }
    .id-card-footer {
        background-color: #f0f0f0;
        padding: 10px;
        border-top: 1px solid #ccc;
    }
    .id-card-text {
        font-size: 14px;
    }
    .id-card-title {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 0px;
    }
    .id-card-footer {
        padding: 10px;
        border-top: 6px solid #ffc94ea6;
    }
</style>
</head>
<body>
            @foreach($students as $student)
                @php
                    $student_image = $student->profile_image ? $student->profile_image : 'uploads/student/graduated_student.png';
                @endphp
                    <div class="id-card">
                        
                        <div class="id-card-header">
                                @php
                                    $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : '/default/default.png';
                                @endphp
                               <center><img src="{{public_path($logo_path)}}" ></center> 
                        </div>
                        <div class="id-card-body">
                            <div class="student-image">
                                <img src="{{ public_path($student_image) }}" alt ="Student Image">
                            </div>
                            <div class="student-info">
                                <h3 class="id-card-title">{{"$student->first_name $student->last_name"}}</h3>
                                <p class="id-card-text">
                                    <strong>Student ID:</strong> {{ $student->student_id_no ?? "" }}<br>
                                    <strong>Roll:</strong> {{ $student->class_roll ?? "" }}<br>
                                    <strong>Class:</strong> {{ $student->studentClass->class_name ?? "" }}<br>
                                    <strong>Shift:</strong> {{ $student->shift->shift_name ?? "" }} <br>
                                    <strong>Section:</strong> {{ $student->section->section_name ?? "" }}<br>
                                    <strong>DOB:</strong> {{ $student->date_of_birth ?? "" }}
                                </p>
                            </div>
                            <img src="{{ public_path('/signature/principal.jpg') }}" alt="" style="width: 100px; height: 30px;"/>
                            <p class="id-card-text">Principal's Signature</p>
                        </div>
                    </div>
            
            @endforeach

</body>
</html>