@extends('layouts.master')

@section('content')
    @if(isset($error))
        <div class="alert alert-danger">{{ $error }}</div>
    @endif
    <div class="card">
        <div class="card-body card__head">
            <form action="{{ route('student.promotion.create') }}" method="GET">
                <div class="row mb-3">
                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                            <option value="">Exam</option>
                            @foreach ($exams as $exam)
                                <option value="{{ $exam->id }}" {{ $loop->first ? 'selected' : '' }}>
                                    {{ $exam->exam_name . ' ' . $exam->academic_year->year }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-12 p-3">
                        <label>From : </label>
                        <div class="row">
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($shifts, 'class="form-control from_shift" id="from_shift" name="from_shift" required', request()->query('from_shift'), "Shift") }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($classes, 'class="form-control from_class" id="from_class" name="from_class" required', request()->query('from_class'), 'From Class') }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown([], 'class="form-control from_section" id="from_section" name="from_section" ', request()->query('from_section') ?? '', 'From Section') }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($academicYears, 'class="form-control academic_year" id="from_academic_year" name="from_academic_year" required', request()->query('from_academic_year'), "From Year") }}
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 p-3">
                        <label>To <span class="mr-3"></span>: </label>
                        <div class="row">
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($shifts, 'class="form-control to_shift" id="to_shift" name="to_shift" required', request()->query('to_shift'), "Shift") }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($classes, 'class="form-control to_class" id="to_class" name="to_class" required', request()->query('to_class') ?? '', 'To Class') }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown([], 'class="form-control to_section" id="to_section" name="to_section" ', request()->query('to_section') ?? '', 'To Section') }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($academicYears, 'class="form-control academic_year" id="to_academic_year" name="to_academic_year" required', request()->query('to_academic_year') ?? getDefaultAcademicYearID(), "To Year") }}
                            </div>
                            <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                                {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-light-blue">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-3">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Student List</h6>
        </div>

        <form action="{{ route('student.promotion.store') }}" method="POST">
            @csrf
            <div class="table-responsive">
                <table class="table">
                    <thead>
                    <tr>
                        <th>
                            <input type="checkbox" id="select_all"> Select All
                        </th>
                        <th>Roll</th>
                        <th>Std. ID</th>
                        <th>Name</th>
                        <th>Merit Position</th>
                        <th>Total Marks</th>
                        <th>Result Status</th>
                        <th>To Section</th>
                        <th>Group (Optional)</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(isset($students))
                        @foreach($students as $student)
                            <tr class="{{ $student->result_status === 'Fail' ? 'table-danger' : '' }}">
                                <td>
                                    <input type="checkbox" class="student-checkbox" name="student_ids[]"
                                           value="{{ $student->id }}">
                                    <input type="hidden" name="to_section[{{ $student->id }}]"
                                           value="{{ request()->query('to_section') }}">
                                    <input type="hidden" name="previous_roll_number[{{ $student->id }}]"
                                           value="{{ $student->current_position }}">
                                    <input type="hidden" name="current_roll_number[{{ $student->id }}]"
                                           value="{{ $student->merit_position }}">
                                </td>
                                <td>{{ $student->current_position }}</td>
                                <td>{{ $student->student_id_no }}</td>
                                <td>{{ $student->first_name }} {{ $student->last_name }}</td>
                                <td>{{ $student->merit_position }}</td>
                                <td>{{ number_format($student->total_marks) }} </td>
                                <td>
                                    <span
                                        class="badge badge-{{ $student->result_status === 'Pass' ? 'success' : ($student->result_status === 'Fail' ? 'danger' : 'warning') }}">
                                        {{ $student->result_status }}
                                    </span>
                                </td>
                                <td>
                                    {{ generateDropdown([], 'class="form-control form-control-sm to_section" id="to_section" name="to_section['.$student->id.']"', request()->query('to_section') ?? '', 'To Section') }}
                                </td>
                                <td>
                                    {{ generateDropdown($groups, 'class="form-control form-control-sm group" id="group" name="group['.$student->id.']"', request()->query('group'), 'Group') }}
                                </td>
                            </tr>
                        @endforeach
                        <input type="hidden" name="from_shift" value="{{ request()->query('from_shift') }}">
                        <input type="hidden" name="from_class" value="{{ request()->query('from_class') }}">
                        <input type="hidden" name="from_section" value="{{ request()->query('from_section') }}">
                        <input type="hidden" name="to_academic_year" value="{{ request()->query('to_academic_year') }}">

                        <input type="hidden" name="to_shift" value="{{ request()->query('to_shift') }}">
                        <input type="hidden" name="to_class" value="{{ request()->query('to_class') }}">
                        <input type="hidden" name="from_academic_year"
                               value="{{ request()->query('from_academic_year') }}">
                    @else
                        <tr>
                            <td colspan="11" class="text-center">No data found</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
            @if(isset($students))
                <div class="card-footer d-flex justify-content-end">
                    <button type="submit" class="btn btn-success"
                            onclick="return confirm('Are you sure you want to promote these students?')">Promote
                        Selected Students
                    </button>
                </div>
            @endif
        </form>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            //form class wise section

            let from_class_id = "{{ request()->query('from_class') ?? '' }}";
            let from_section_id = "{{ request()->query('from_section') ?? '' }}";

            if (from_class_id != '') {
                getSection(from_class_id, from_section_id).then(sections => {
                    let option = '<option value="">From Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (from_section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.from_section').empty().append(option);
                });
            }

            $('.from_class').on('change', function () {
                let from_class_id = $(this).val();
                getSection(from_class_id, from_section_id).then(sections => {
                    let option = '<option value="">From Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (from_section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.from_section').empty().append(option);
                });
            });

            //to class wise section same as from class wise section
            let to_class_id = "{{ request()->query('to_class') ?? '' }}";
            let to_section_id = "{{ request()->query('to_section') ?? '' }}";
            if (to_class_id != '') {
                getSection(to_class_id, to_section_id).then(sections => {
                    let option = '<option value="">To Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (to_section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.to_section').empty().append(option);
                });
            }

            $('.to_class').on('change', function () {
                let to_class_id = $('.to_class').val();
                getSection(to_class_id, to_section_id).then(sections => {
                    let option = '<option value="">To Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (to_section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.to_section').empty().append(option);
                });
            });

            function getSection(student_class_id, selected_section_id) {
                return new Promise((resolve) => {
                    if (student_class_id) {
                        $.get('{{ route('sections.list_by_class') }}', {student_class_id: student_class_id}, function (response) {
                            console.log('response', response);
                            resolve(response);
                        });
                    } else {
                        resolve([]);
                    }
                });
            }

            // Select All functionality
            $('#select_all').on('change', function () {
                $('.student-checkbox').prop('checked', this.checked);
            });
        });
    </script>
@endsection

