@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">
            <!-- Nav tabs -->
            <div class="d-flex justify-content-between align-items-start">
                <ul class="nav nav-tabs flex-grow-1">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->query('tab', 'search') === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">
                            Search By ID
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->query('tab') === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">
                            Search by Class
                        </a>
                    </li>
                </ul>

                @can('student.student-list.create')
                    <a href="{{ route('student_info.create') }}" class="btn btn-light-blue ml-3">
                        Add New
                    </a>
                @endcan
                
                
            </div>

            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab" class="tab-pane {{ request()->query('tab', 'search') === 'search' ? 'show active' : '' }}">
                    <form method="GET" action="{{ route('student_info.index') }}" class="row">
                        <input type="hidden" name="tab" value="search">
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            @component('components.search_student', [
                                'student_name' => $student_name ?? '',
                                'student_id_no' => request()->student_id_no ?? '',
                                'required' => '',
                            ])
                            @endcomponent
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab" class="tab-pane fade {{ request()->query('tab') === 'filter' ? 'show active' : '' }}">
                    <form method="GET" action="{{ route('student_info.index') }}" class="row">
                        <input type="hidden" name="tab" value="filter">
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            {{ generateDropdown($studentClasses, 'class="form-control student_class student_class_id select2" id="student_class" name="student_class" required', request()->query('student_class'), "Class") }}
                        </div>
                        
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                        </div>
                        
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                        </div>
                        <x-group-selector
                            name="group"
                            label=""
                            labelText="Group"
                            col="form-group col-lg-2 col-md-6 col-sm-6"
                            :student_class_id="(int) request()->input('student_class')"
                            :required="(int) request()->input('student_class') >= 11"
                            :selected="old('group') ?? request()->input('group')"
                        />

                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            {{ generateDropdown(Status::STUDENT_STATUS(), 'class="form-control status" id="status" name="status"', request()->query('status'), "") }}
                        </div>
                        <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4 d-none" id="print-layout">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Student Manage</h6>
            <div class="m-0 float-right">
                <x-report-actions :columns="[
                    'class_roll' => 'Roll',
                    'student_id_no' => 'Student ID',
                    'name' => 'Name',
                    'student_class.class_name' => 'Class',
                    'section.section_name' => 'Section',
                    'mobile_no' => 'Mobile NO',
                ]" :print="true" :exportPdf="true" :exportExcel="true" />
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table_content cell-border table-bordered" id="studentsTable">
                        <thead class="thead-light">
                            <tr>
                                <th>Roll</th>
                                <th>Std. ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Mobile No</th>
                                <th>Status</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        $(document).ready(function() {
            let query = @json(request()->query());
            let table;
            const assetUrl = "{{ asset('') }}";
            if (Object.keys(query).length > 0) {
                $("#print-layout").removeClass("d-none");
                table = $('#studentsTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{!! route('student_info.index') !!}',
                        type: 'GET',
                        data: function(d) {
                            $.extend(d, query);
                        }
                    },
                    columns: [
                        { data: 'class_roll', name: 'class_roll' },
                        { data: 'student_id_no', name: 'student_id_no', orderable: false, searchable: false },
                        { data: 'name', name: 'name' },
                        { data: 'student_class.class_name', name: 'student_class.class_name' },
                        {
                            data: 'section.section_name',
                            name: 'section.section_name',
                            render: function(data, type, row) {
                                return row.section ? row.section.section_name : '--';
                            }
                        },
                        {
                            data: 'mobile_no',
                            name: 'mobile_no',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'status',
                            name: 'status',
                            orderable: false,
                            searchable: false,
                            render: function (data, type, row) {
                                let checked = data == 'active' ? 'checked' : '';
                                return `
                                    <div class="custom-control custom-switch text-center">
                                        <input type="checkbox"
                                            class="custom-control-input status-switch"
                                            id="switch_${row.id}"
                                            data-id="${row.id}"
                                            ${checked}>
                                        <label class="custom-control-label" for="switch_${row.id}"></label>
                                    </div>
                                `;
                            }
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                let viewButton = '<a href="{{ route("student_info.view", ":student_id_no") }}'.replace(":student_id_no", row.student_id_no) + '" class="btn btn-sm btn-soft-info mr-1" data-toggle="tooltip" title="View" target="_blank"><i class="fas fa-eye"></i></a>';
                                let editButton = '<a href="{{ route("student_info.edit", ":id") }}'.replace(":id", row.id) + '" class="btn btn-sm btn-soft-success mr-1" data-toggle="tooltip" title="Edit"><i class="fas fa-edit"></i></a>';
                                let deleteButton = '<a href="{{ route("student_info.destroy", ":id") }}'.replace(":id", row.id) + '" class="btn btn-sm btn-soft-danger mr-1" data-toggle="tooltip" title="Delete"><i class="fas fa-trash"></i></a>';
                                return '<div class="d-flex justify-content-center">' + viewButton + editButton + deleteButton + '</div>';
                            }
                        }
                    ],
                    language: {
                        emptyTable: "No data available in table",
                        zeroRecords: "No matching records found",
                        processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
                    }
                });

                // Initialize column toggle after table is created
                initializeColumnToggle(table, {
                    'class_roll': 0,
                    'student_id_no': 1,
                    'name': 2,
                    'student_class.class_name': 3,
                    'section.section_name': 4,
                    'mobile_no': 5,
                });
            }
        });

        $(document).on('change', '.status-switch', function () {
            let studentId = $(this).data('id');
            let status = $(this).is(':checked') ? 'active' : 'inactive';

            $.ajax({
                url: "{{ route('student.status.update') }}",
                type: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    id: studentId,
                    status: status
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                    }
                },
                error: function () {
                    toastr.error('Something went wrong');
                }
            });
        });


        const exportExcelOptions = {
            url: '{{ route("students.information.export-excel") }}',
            filename: 'student-information',
            extraData: @json(request()->query()),
        };

        const exportPdfOptions = {
            url: '{{ route("students.information.export-pdf") }}',
            filename: 'student-information',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("students.information.export-print") }}',
            extraData: @json(request()->query()),
        };

        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){

            let section_id = "{{ request()->query('section') ?? '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">Section</option>';
                    for(let i=0;i<sections.length;i++){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }

    </script>
@endsection
