@extends('layouts.master')

@section('content')
<style>
    .image-uploader {
        display: flex;
        flex-direction: column;
        align-items: center;
        position: relative; /* Add position relative */
    }

    .image-uploader__label {
        display: flex;
        flex-direction: column;
        align-items: center;
        cursor: pointer;
        position: relative; /* Add position relative */
    }

    .image-uploader__icon-overlay {
        position: absolute;
        top: 50%; /* Align vertically centered */
        left: 50%; /* Align horizontally centered */
        transform: translate(-50%, -50%); /* Center the icon */
        width: 100%;
        height: calc(100%); /* Height equal to parent minus icon height */
        background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
        border-radius: 50%; /* Rounded border */
        display: flex;
        justify-content: center;
        align-items: center;
        opacity: 0.3;
    }

    .image-uploader__icon-overlay i {
        color: #ffffff; /* Icon color */
        font-size: 24px; /* Icon size */
    }

    /* Your existing styles */
    .image-uploader__preview {
        overflow: hidden;
    }

    .image-uploader__input {
        display: none;
    }

</style>
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Show Student Profile</h6>
        <div class="m-0 float-right">
            <a class="btn btn-sm btn-primary" href="{{ route('student_info.index') }}">Student List</a>
        </div>
    </div>
    <div class="card-body m-3">
        <form action="{{ route('student_info.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row p-2 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Personal Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">First Name </label>
                                <input type="text" class="form-control" id="first_name" value="{{$studentInfo->first_name ?? ""}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="last_name">Last Name </label>
                                <input type="text" class="form-control" value="{{$studentInfo->last_name ?? ""}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">Gender  </label>
                                <input type="text" class="form-control" value="{{$studentInfo->gender ?? ""}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">Blood Group  </label>
                                <input type="text" class="form-control" value="{{$studentInfo->blood_group ?? ""}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">Religion  </label>
                                <input type="text" class="form-control" value="{{$studentInfo->religion ?? ""}}" readonly>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="first_name">Date Of Birth  </label>
                                <input type="text" class="form-control" value="{{$studentInfo->date_of_birth ?? ""}}" readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <label for="first_name">Profile Image  </label>
                    <div class="form-group mb-3">
                        @php
                            $student_image = $studentInfo->profile_image ? $studentInfo->profile_image : 'graduated_student.png';
                        @endphp
                        <img id="preview" src="{{ asset("uploads/student/$student_image") }}" alt="Image Preview" class="img-thumbnail rounded-circle border p-1" style="width: 150px; height: 150px;">
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Birth Certificate No  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->birth_certi_no ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Mobile Number  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->mobile_no ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Email  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->email ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="first_name">Present Address  </label><br>
                        <input type="text" class="form-control" value="{{$studentInfo->present_address ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="first_name">Permanent Address  </label><br>
                        <input type="text" class="form-control" value="{{$studentInfo->permanent_address ?? ""}}" readonly>
                    </div>
                </div>
            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Academic Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Shift  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->shift->shift_name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Class  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->studentClass->class_name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Section  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->section->section_name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Group  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->group->group_name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Admission Roll  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->admission_roll ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Class Roll  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->class_roll ?? ""}}" readonly>
                    </div>
                </div>

            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Hostel Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="hostel">Hostel  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->studentHostel->hostel->name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        <label for="hostel">Floor  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->studentHostel->hostelFloor->name ?? ""}}" readonly>
                    </div>
                </div>

                <div class="col-md-5">
                    <div class="form-group">
                        <label for="hostel">Room  </label>
                        @php
                            $room_no = $studentInfo->studentHostel->hostelRoom->room_name ?? "";
                            $room_type = $studentInfo->studentHostel->hostelRoom->roomType->name ?? "";
                            $cost_per_bed = $studentInfo->studentHostel->hostelRoom->roomType->cost_per_bed ?? "";
                            $room_str = ($room_no && $cost_per_bed) ? $room_no." => ".$room_type." => (Tk.".$cost_per_bed.")" : "";
                        @endphp
                        <input type="text" class="form-control" value="{{$room_str}}" readonly>
                    </div>
                </div>
            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Transport Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="code">Routes</label>
                        <input type="text" class="form-control" value="{{$studentInfo->studentTransport->transportRoute->route_name ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="code">Stoppage</label>
                        @php
                            $stoppage_name = $studentInfo?->studentTransport?->stoppage?->name ?? "";
                            $monthly_cost = round($studentInfo?->studentTransport?->stoppage?->monthly_cost) ?? "";
                            $stoppage_str = ($stoppage_name!="" && $monthly_cost!="") ? $stoppage_name." => (Tk. ".$monthly_cost.")" : "";
                        @endphp
                        <input type="text" class="form-control" value="{{$stoppage_str}}" readonly>
                    </div>
                </div>
            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Parent Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Father Name  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->father_name ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Father Occupation  </label>
                        <input type="text" class="form-control" value="{{ $occupations[$studentInfo->father_occupation] ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Father Mobile No  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->father_mobile ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Mother Name  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->mother_name ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Mother Occupation  </label>
                        <input type="text" class="form-control" value="{{ $occupations[$studentInfo->mother_occupation] ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Mother Mobile  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->mother_mobile ?? ""}}" readonly>
                    </div>
                </div>
            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Sibling Info
            </div>
            <div class="row p-2" style="background-color: #fff4ea; border-radius: 4px">
                <div class="col-md-4">
                    <div id="siblings-list">
                        @forelse ($studentInfo->siblings as $sibling)
                            <div class="sibling-item mb-1 p-1 bg-light d-flex justify-content-between align-items-center">
                                <span>{{$sibling->name}} (ID-{{$sibling->student_id_no}})</span>
                            </div>
                        @empty
                            
                        @endforelse

                    </div>
                </div>
            </div>

            <div class="row p-2 mt-3 mb-3 rounded text-white font-weight-bold" style="background-color: #ffaf61">
                Gurdian Info
            </div>

            <div class="row p-2" style="background-color: #fff4ea; border-radius:4px">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Gurdian Name  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->guardian_name ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Gurdian Occupation  </label>
                        <input type="text" class="form-control" value="{{$occupations[$studentInfo->guardian_occupation] ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Gurdian Mobile  </label>
                        <input type="text" class="form-control" value="{{$studentInfo->guardian_mobile ?? ""}}" readonly>
                    </div>
                </div>


                <div class="col-md-4">
                    <div class="form-group">
                        <label for="first_name">Relation with Guardian  </label>
                        <input type="text" class="form-control" value="{{$guardian_relations[$studentInfo->guardian_relationship] ?? ""}}" readonly>
                    </div>
                </div>
                <div class="col-md-8">

                    <label for="first_name">Gurdian Address  </label>
                    <input type="text" class="form-control" value="{{$studentInfo->guardian_address ?? ""}}" readonly>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    function previewPhoto(event) {
        var preview = document.getElementById('profile_image');
        var file = event.target.files[0];
        var reader = new FileReader();
        reader.onload = function() {
            preview.src = reader.result;
        }
        reader.readAsDataURL(file);
    }
</script>
@endsection

@section('scripts')
    <script>
        $('.student_class').on('change', function(){

            let _this = $(this);
            let student_class_id =  _this.val();
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    console.log(sections)
                    let option = '<option value="">Select Section</option>';
                    for(let i=0;i<sections.length;i++){
                        if(sections[i].student_class_id == student_class_id){
                           option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.sections').empty().append(option);
                });
            }
        });
    </script>
@endsection
