@extends('layouts.master')
@section('content')
    <style>
        .border-tab.nav-tabs .nav-item .nav-link.active, .border-tab.nav-tabs .nav-item .nav-link.show, .border-tab.nav-tabs .nav-item .nav-link:focus {
            border-bottom: 3px solid #4466f2;
        }

        .border-tab.nav-tabs .nav-item .nav-link.active, .border-tab.nav-tabs .nav-item .nav-link.show, .border-tab.nav-tabs .nav-item .nav-link:focus, .border-tab.nav-tabs .nav-item .nav-link:hover {
            color: #4466f2;
            font-weight: 500;
        }

        .nav-tabs .nav-link {
            border: none;
        }

        /*.tabbed-card ul.border-tab.nav-tabs .nav-item .nav-link {*/
        /*    padding: 10px 15px;*/
        /*    color: #000;*/
        /*}*/

        .tab-pane .t-card {
            border-bottom: 1px solid #d7dfe3;
            border-left: 1px solid #d7dfe3;
            border-right: 1px solid #d7dfe3;
            margin-bottom: 16px;
        }

        .pagetitleh2 {
            color: var(--light-blue-active);
            background-color: #eaecf4;
            font-size: 15px;
            font-weight: 500;
            background-color: #e1ecff !important;
            padding: .85rem .75rem;
            padding-right: 1.5rem;
            padding-left: 1.5rem;

        }
        .table .thead-light th:first-child, .card .table td:first-child {
            text-align: left;
            font-size: 16px;
            width: auto !important;
        }
        .th__month{
            width: 180px;
        }

        /*profile info*/
        .profile-intro {
            /*    background-image: linear-gradient(60deg, #f56600, #FF9800);*/
        }

        .profile-intro .avatar {
            border-color: #511291;
        }

        .profile-intro, .profile-intro h4, .profile-intro table {
            color: #000;
        }

        .content .avatar img {
            width: 120px;
            margin: 15px auto;
            margin-bottom: 17px;
            background: #EEE;
            height: 120px;
            object-fit: cover;
            border-radius: 1000px;
            border: 2px solid #e7e7e7;
        }

        .profile-intro tr th {
            text-align: left;
        }

        .profile-intro tr td {
            text-align: right;
        }

        .profile-intro tr th,
        .profile-intro tr td {
            color: #000;
        }

        /* attendance-details */
        .attendance-details table {
            width: 100%;
            border-collapse: collapse;
        }

        .attendance-details th, .attendance-details td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
        }

        .attendance-details th {
            background-color: #f4f4f4;
        }

        .attendance-details th,
        .attendance-details td {
            width: 7.692% !important;
        }

        .attendance-details .present {
            background-color: #4CAF50;
            color: white;
        }

        .attendance-details .absent {
            background-color: #f44336;
            color: white;
        }

        .attendance-details .late {
            background-color: #8a6d3b;
            color: white;
        }

        table th.exam__th{
            background: #06995f !important;
            color: #fff;
            border: 1px solid #06995f;
            font-size: 16px;
            margin-bottom: 5px;
        }

        .t-card .table td:last-child{
            text-align: left;
        }

    </style>
    <div class="row">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body profile-intro">
                    @php
                        $student_image = $studentInfo->profile_image ? $studentInfo->profile_image : 'graduated_student.png';

                        use Carbon\Carbon;
                        $birthdate = $studentInfo->date_of_birth; // Example birthdate
                        try {
                            // Parse the birthdate
                            $birthdate = Carbon::createFromFormat('Y-m-d', $birthdate);
                            $now = Carbon::now();
                            $age = $birthdate->diff($now)->format('Age: %y Years, %m Months, %d Days');
                        } catch (\Exception $e) {
                            // Handle the error if the date parsing fails
                            $age = 'Invalid date format';
                        }

                    @endphp
                    <div class="content text-center">
                        <div class="avatar">
                            <img src="{{ asset("uploads/student/$student_image") }}"
                                 alt="{{ $studentInfo->name ?? 'N/A'}}">
                        </div>
                        <h4 class="profile-user">{{ $studentInfo->name ?? 'N/A'}}</h4>
                        <p class="profile-job">
                        </p>
                        <table class="table mt-20">
                            <tbody>
                            <tr>
                                <th>ID</th>
                                <td>{{ $studentInfo->student_id_no ?? 'N/A'}}</td>
                            </tr>
                            <tr>
                                <th>Session</th>
                                <td>2025</td>
                            </tr>
                            <tr>
                                <th>Class</th>
                                <td>{{ $studentInfo->studentClass->class_name ?? 'N/A'}}</td>
                            </tr>
                            <tr>
                                <th>Section</th>
                                <td>{{ $studentInfo->section->section_name ?? 'N/A'}}</td>
                            </tr>
                            <tr>
                                <th>Roll</th>
                                <td>{{ $studentInfo->class_roll ?? 'N/A'}}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <div class="card">
                <div class="card-body">
                    <div class="tabbed-card">
                        <ul class="nav nav-tabs border-tab" id="top-tab" role="tablist">
                            <li class="nav-item"><a class="nav-link active" id="profile-top-tab" data-toggle="tab"
                                                    href="#top-profile" role="tab" aria-controls="top-profile"
                                                    aria-selected="true">Profile</a>
                                <div class="material-border"></div>
                            </li>
                            <li class="nav-item"><a class="nav-link" id="fees-top-tab" data-toggle="tab"
                                                    href="#top-fees" role="tab" aria-controls="top-fees"
                                                    aria-selected="false">Fees</a>
                                <div class="material-border"></div>
                            </li>
                            <li class="nav-item"><a class="nav-link" id="exam-top-tab" data-toggle="tab"
                                                    href="#top-exam" role="tab" aria-controls="top-exam"
                                                    aria-selected="false">Exam</a>
                                <div class="material-border"></div>
                            </li>
                            <li class="nav-item"><a class="nav-link" id="attendance-top-tab" data-toggle="tab"
                                                    href="#top-attendance" role="tab" aria-controls="top-attendance"
                                                    aria-selected="false">Attendance</a>
                                <div class="material-border"></div>
                            </li>
                        </ul>
                        <div class="tab-content" id="top-tabContent">
                            <div class="tab-pane fade active show" id="top-profile" role="tabpanel"
                                 aria-labelledby="profile-top-tab">
                                <div class="t-card">
                                    <h3 class="pagetitleh2">Personal Information</h3>
                                    <div class="table-responsive">
                                        <table class="table table-borderless table-sm table-hover">
                                            <tbody class="text-left">
                                            <tr>
                                                <td>Date of Birth</td>
                                                <td>{{ $studentInfo->date_of_birth ?  Carbon::parse($studentInfo->date_of_birth)->format('jS F, Y') : 'N/A' }}
                                                    <span style="color: red;">( {{$age}} )</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Mobile No</td>
                                                <td>{{ $studentInfo->mobile_no ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Email</td>
                                                <td>{{ $studentInfo->email ?? 'N/A'}}</td>
                                            </tr>

                                            <tr>
                                                <td>Religion</td>
                                                <td>{{ $studentInfo->religion ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Birth Certificate</td>
                                                <td>{{ $studentInfo->birth_certi_no ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Admission Roll</td>
                                                <td>{{ $studentInfo->admission_roll ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Admitted Year</td>
                                                <td>{{ $studentInfo->year_admitted ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Branch</td>
                                                <td>{{ $studentInfo->branch->branch_name ?? 'N/A'}}</td>
                                            </tr>

                                            <tr>
                                                <td>Gender</td>
                                                <td class="text-capitalize">{{ $studentInfo->gender ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Blood Group</td>
                                                <td>{{ $studentInfo->blood_group ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Group</td>
                                                <td>{{ $studentInfo->group->group_name ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Present Address</td>
                                                <td>{{ $studentInfo->present_address ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Permanent Address</td>
                                                <td>{{ $studentInfo->permanent_address ?? 'N/A'}}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="t-card">
                                    <h3 class="pagetitleh2">Parent Information</h3>
                                    <div class="table-responsive">
                                        <table class="table table-borderless table-sm table-hover">
                                            <tbody>
                                            <tr>
                                                <td>Father Name</td>
                                                <td>{{ $studentInfo->father_name ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Father Mobile</td>
                                                <td>{{ $studentInfo->father_mobile ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Father Occupation</td>
                                                <td>{{ $occupations[$studentInfo->father_occupation] ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Mother Name</td>
                                                <td>{{ $studentInfo->mother_name ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Mother Mobile</td>
                                                <td>{{ $studentInfo->mother_mobile ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Mother Occupation</td>
                                                <td>{{ $occupations[$studentInfo->mother_occupation] ?? 'N/A'}}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="t-card">
                                    <h3 class="pagetitleh2">Guardian Information</h3>
                                    <div class="table-responsive">
                                        <table class="table table-borderless table-sm table-hover">
                                            <tbody>
                                            <tr>
                                                <td>Guardian Name</td>
                                                <td>{{ $studentInfo->guardian_name ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Guardian Mobile</td>
                                                <td>{{ $studentInfo->guardian_mobile ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Guardian Occupation</td>
                                                <td>{{ $occupations[$studentInfo->guardian_occupation] ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Guardian Relationship</td>
                                                <td>{{ $guardian_relations[$studentInfo->guardian_relationship] ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <td>Guardian Address</td>
                                                <td>{{ $studentInfo->guardian_address ?? 'N/A'}}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="top-fees" role="tabpanel" aria-labelledby="fees-top-tab">
                                <div class="table-responsive py-2">

                                    <table class="table t-card">
                                        <thead>
                                        <tr>
                                            <th class="th__month">Month</th>
                                            <th>Fee Type</th>
                                            <th class="text-center">Total Amount</th>
                                            <th class="text-center">Status</th>
                                        </tr>
                                        </thead>
                                        <tbody class="day-schedule ">
                                        @foreach($fees as $fee)
                                            <tr class="subject-entry">
                                                <td>{{ $fee['month'] ?? 'N/A' }}</td>
                                                <td>
                                                    @foreach ($fee['fee_types'] as $fee_type)
                                                        <span>{{ $fee_type['fee_type_name']." : ".$fee_type['amount'] }} Tk,</span>
                                                    @endforeach
                                                </td>
                                                <td class="text-center">{{ $fee['total_amount'] ?? '0.00' }}</td>
                                                <td class="text-center">
                                                    @if($fee['payment_status'] == 'Due')
                                                        {!! getStatusBadge(Status::DUE) !!}
                                                    @else
                                                        {!! getStatusBadge(Status::PAID) !!}
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach


                                        </tbody>
                                    </table>
                                </div>

                            </div>
                            <div class="tab-pane fade" id="top-exam" role="tabpanel" aria-labelledby="exam-top-tab">
                                @foreach ($examMarks as $year => $yearGroup)
                                    @foreach ($yearGroup as $examId => $marks)
                                        @php
                                            $exam_year = $marks->first()->academicYear->year ?? '';
                                        @endphp
                                        @php
                                            // Get all the assigned marks for the subjects in the exam and class
                                            $assignedMarksHead = App\Models\Result\MarkHeadAssign::where('exam_id', $examId)
                                                ->where('student_class_id', $studentInfo->student_class_id)
                                                ->get(); // Use get() to retrieve the collection of models

                                            $head_marks_array = [];
                                            foreach ($assignedMarksHead as $assignedHead) {
                                                // Decode the JSON head_marks for each subject and assign it to the array
                                                $head_marks_array[$assignedHead->subject_id] = is_array($assignedHead->head_marks)
                                                    ? $assignedHead->head_marks
                                                    : json_decode($assignedHead->head_marks, true);
                                            }

                                            // Get the list of head ids from the head_marks array
                                            $head_id_array = array_keys($head_marks_array);
                                        @endphp

                                        <table class="table table-bordered mb-3">
                                            <thead>
                                            <tr class="mb-2">
                                                <th colspan="6"
                                                    class="text-left exam__th">{{ $marks->first()->exam->exam_name }} {{$exam_year}}</th>
                                            </tr>
                                            <tr>
                                                <th>Subject</th>
                                                <th>Full Marks</th>
                                                @foreach ($markHeads as $head)
                                                    @if (in_array($head->id, $head_id_array))
                                                        <th>{{ $head->short_name }}</th>
                                                    @endif
                                                @endforeach
                                                <th class="text-center">Total Obt.</th>
                                                <th class="text-center">Grade</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach ($marks as $mark)
                                                @php
                                                    $full_marks = 0;
                                                    $head_wise_total_obtain = [];
                                                    $total_marks_obtain = 0;
                                                    $head_records_str = '';

                                                    $head_wise_marks_record = json_decode($mark->head_wise_marks);
                                                    $head_marks_data = $head_marks_array[$mark->subject->id] ?? [];
                                                @endphp

                                                <tr>
                                                    <td>{{ $mark->subject->subject_name }}</td>
                                                    <!-- Assuming 'name' column in subjects table -->

                                                    @if (isset($head_wise_marks_record))

                                                        @foreach ($markHeads as $head)
                                                            @if (in_array($head->id, $head_id_array))
                                                                @php
                                                                    $full_marks += $head_marks_data[$head->id] ?? 0;
                                                                    $head_records_str .= "<td>" . ($head_wise_marks_record->{$head->id} ?? "-") . "</td>";
                                                                    $total_marks_obtain += $head_wise_marks_record->{$head->id} ?? 0;
                                                                    $head_wise_grand_total[$head->id] = ($head_wise_grand_total[$head->id] ?? 0) + ($head_wise_marks_record->{$head->id} ?? 0);
                                                                @endphp
                                                            @endif
                                                        @endforeach

                                                        <td class="bg-gray">{{ $full_marks }}</td>
                                                        {!! $head_records_str !!}
                                                    @endif

                                                    <td class="text-center">{{ $mark->total_marks }}</td>
                                                    <td class="text-center">
                                                        @php
                                                            $subject_grade_name = '';
                                                            $fail_count = 0;
                                                            $total_percentage =
                                                                $total_marks_obtain > 0 && $full_marks > 0
                                                                    ? round(($total_marks_obtain * 100) / $full_marks)
                                                                    : 0;
                                                            foreach ($grades as $grade) {
                                                                if ($grade->mark_from <= $total_percentage && $grade->mark_to >= $total_percentage) {
                                                                    $subject_grade_name = $grade->name;
                                                                    if ($subject_grade_name == 'F') {
                                                                        $fail_count++;
                                                                    }
                                                                }
                                                            }
                                                        @endphp
                                                        {{ $subject_grade_name ?? '' }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    @endforeach
                                @endforeach


                            </div>
                            <div class="tab-pane fade" id="top-attendance" role="tabpanel"
                                 aria-labelledby="attendance-top-tab">
                                @if(!empty($attendanceStatsCount))
                                    <div class="row">
                                        @foreach($attendanceStatsCount as $stat)
                                            <div class="col-xl-3 col-md-6 col-6 mb-4">
                                                <div class="card h-100 item"
                                                     style="border-left: 4px solid var(--blue);">
                                                    <div class="card-body">
                                                        <div class="row no-gutters align-items-center">
                                                            <div class="col mr-2">
                                                                <div
                                                                    class="text-xs font-weight-bold text-uppercase mb-1">
                                                                    Total Present
                                                                </div>
                                                                <div
                                                                    class="h5 mb-0 font-weight-bold text-gray-800">{{$stat->present_count ?? 0}}</div>
                                                                <div class="mt-2 mb-0 text-muted text-xs">
                                                                    <span class="text-success mr-2"><i
                                                                            class="fa fa-arrow-down"></i></span>
                                                                    <span>Since This Year</span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <i class="fa fa-check"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-3 col-md-6 col-6 mb-4">
                                                <div class="card h-100 item"
                                                     style="border-left: 4px solid var(--blue);">
                                                    <div class="card-body">
                                                        <div class="row no-gutters align-items-center">
                                                            <div class="col mr-2">
                                                                <div
                                                                    class="text-xs font-weight-bold text-uppercase mb-1">
                                                                    Total Absent
                                                                </div>
                                                                <div
                                                                    class="h5 mb-0 font-weight-bold text-gray-800">{{$stat->absent_count ?? 0}}</div>
                                                                <div class="mt-2 mb-0 text-muted text-xs">
                                                                    <span class="text-success mr-2"><i
                                                                            class="fa fa-arrow-down"></i></span>
                                                                    <span>Since This Year</span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <i class="fa fa-check"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-3 col-md-6 col-6 mb-4">
                                                <div class="card h-100 item"
                                                     style="border-left: 4px solid var(--blue);">
                                                    <div class="card-body">
                                                        <div class="row no-gutters align-items-center">
                                                            <div class="col mr-2">
                                                                <div
                                                                    class="text-xs font-weight-bold text-uppercase mb-1">
                                                                    Total Late
                                                                </div>
                                                                <div
                                                                    class="h5 mb-0 font-weight-bold text-gray-800">{{$stat->late_count ?? 0}}</div>
                                                                <div class="mt-2 mb-0 text-muted text-xs">
                                                                    <span class="text-success mr-2"><i
                                                                            class="fa fa-arrow-down"></i></span>
                                                                    <span>Since This Year</span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <i class="fa fa-check"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-3 col-md-6 col-6 mb-4">
                                                <div class="card h-100 item"
                                                     style="border-left: 4px solid var(--blue);">
                                                    <div class="card-body">
                                                        <div class="row no-gutters align-items-center">
                                                            <div class="col mr-2">
                                                                <div
                                                                    class="text-xs font-weight-bold text-uppercase mb-1">
                                                                    Total Days
                                                                </div>
                                                                <div
                                                                    class="h5 mb-0 font-weight-bold text-gray-800">{{$stat->total_days ?? 0}}</div>
                                                                <div class="mt-2 mb-0 text-muted text-xs">
                                                                    <span class="text-success mr-2"><i
                                                                            class="fa fa-arrow-down"></i></span>
                                                                    <span>Since This Year</span>
                                                                </div>
                                                            </div>
                                                            <div class="col-auto">
                                                                <i class="fa fa-check"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif


                                <div class="attendance-details">

                                    <h1>Present: <span style="color:#4CAF50;">P</span> Absent: <span
                                            style="color:#f44336;">A</span> Late: <span style="color:#8a6d3b;">L</span>
                                    </h1>
                                    <table>
                                        <thead>
                                        <tr>
                                            <th>Date</th>
                                            @foreach(range(1, 12) as $month)
                                                <th>{{ \Carbon\Carbon::create()->month($month)->format('F') }}</th>
                                            @endforeach
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach(range(1, 31) as $day)
                                            <tr>
                                                <td>{{ $day }}</td>
                                                @foreach(range(1, 12) as $month)
                                                    <td class="
                            @if(isset($attendanceByDay[$month][$day]))
                                                    @if($attendanceByDay[$month][$day]['is_present'] == 1) present
                                @elseif($attendanceByDay[$month][$day]['is_absent'] == 1) absent
                                @elseif($attendanceByDay[$month][$day]['is_late'] == 1) late
                                @else
                                                    @endif
                                                    @else

                                                    @endif
                                                        ">
                                                        @if(isset($attendanceByDay[$month][$day]))
                                                            @if($attendanceByDay[$month][$day]['is_present'] == 1)
                                                                P
                                                            @elseif($attendanceByDay[$month][$day]['is_absent'] == 1)
                                                                A
                                                            @elseif($attendanceByDay[$month][$day]['is_late'] == 1)
                                                                L
                                                            @else

                                                            @endif
                                                        @else

                                                        @endif
                                                    </td>
                                                @endforeach
                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
