@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="{{ route('syllabus.status.search') }}" class="row">
                @csrf
               <div class="form-group col-lg-3 col-md-3 col-sm-6">
                    {{ generateDropdown($exams, 'class="form-control exam_id select2" id="exam_id" name="exam_id" required', $exam_id, "Select Exam") }}
                </div>
                <div class="form-group col-lg-3 col-md-3 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class" required', $student_class_id, "Select Class") }}
                </div>
                <div class="form-group col-md-3 col-md-3 col-sm-6">
                    {{ generateDropdown('', 'class="form-control form-control-sm subject_id " id="subject_id" name="subject_id" ', $subject_id, "All Subject") }}
                </div>
                <div class="form-group col-lg-3 col-md-3 col-sm-6">
                    <button type="submit" class="btn btn-info ">Search</button>
                </div>
            </form>
        </div>
    </div>

@if(!empty($lessons))
<div class="card mt-4" id="syllabusStatus">
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table">
                    <thead class="thead-light">
                        @if(!empty($exam_name))
                        <tr class="hide" id="visible">
                            <td colspan="5" class="text-left">@if(!empty($exam_name)) <strong class="font-weight-bold">Exam:</strong> @endif {{ $exam_name ?? '' }}  @if(!empty($class_name)) <strong class="font-weight-bold">Class:</strong> {{ $class_name ?? '' }} @endif</td>
                        </tr>
                        @endif

                        <tr>
                            <th width="30">#</th>
                            <th>
                                <div class="row">
                                    <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                    <div class="col-md-2 col-xs-3">Topic Completion Date</div>
                                    <div class="col-md-2 col-xs-2">Status</div>
                                    <div class="col-md-2 col-xs-2 relative text-right">
                                        <div class="material-switch pull-right"></div>     
                                        Action
                                    </div>
                                </div>    
                           </th>
                        </tr>
                    </thead>

                    <tbody>
                        
                        @if($lessons->isNotEmpty())
                        @php
                            $displayedSubjects = [];
                        @endphp
                        @foreach($lessons as $lessonKey=>$lesson)
                        <tr>
                            <td>{{$lessonKey+1}}</td>
                            <td>
                                @if(!in_array($lesson->subject->id, $displayedSubjects))
                                    @php
                                        $displayedSubjects[] = $lesson->subject->id;
                                    @endphp
                                    <h3 class="subject-name">{{ $lesson->subject->subject_name }}</h3>
                                @endif
                                <div class="ml-3">
                                 
                                <h5 class="lesson-name">{{$lesson->name}}</h5>
                                <ul class="list-unstyled ml-3">
                                    @php $topics = lesson_topics($lesson->student_class_id,$lesson->subject_id,$lesson->id); @endphp
                                    @foreach($topics as $topicKey=>$topic)
                                    <li>
                                        <div class="row">
                                            <div class="col-md-6 col-xs-7"><span class="pr15">{{$lessonKey+1}}.{{$topicKey+1}}</span> {{$topic->name}}</div>
                                            <div class="col-md-2 col-xs-3">{{$topic->completed_date}}</div>
                                            <div class="col-md-2 col-xs-2">
                                                @if($topic->status)
                                                <span class="badge badge-success">Completed</span>
                                                @else
                                                <span class="badge badge-danger">Incomplete</span>
                                                @endif
                                            </div>
                                            <div class="col-md-2 col-xs-2 pb5">
                                                <div class="relative text-right">          
                                                    <div class="material-switch">
                                                        <label class="switch">
                                                            <input class="changeUserStatus" type="checkbox"  @if($topic->status) checked @endif>
                                                            <span class="slider round" data-id="{{$topic->id}}" data-status="{{$topic->status}}" data-toggle="modal"
                                                data-target="#dataEditModal"></span>
                                                        </label>

                                                        {{--<div class="custom-control custom-switch custom-switch-inline cursor-pointer">
                                                            <input type="checkbox" class="custom-control-input customSwitch1" data-rowid="{{$topic->id}}" id="customSwitch{{$topic->id}}">
                                                            <label class="custom-control-label" for="customSwitch{{$topic->id}}"></label>
                                                        </div>--}}

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                                </div> 
                            </td>        
                        </tr>
                        @endforeach
                        @else
                            <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endif
@if(!empty($lessons))
<!--edit Modal -->
<div class="modal fade" id="dataEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="{{ route('lesson_topic.status.change') }}">
                @csrf
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h6 class="modal-title" id="myModalLabel">Topic Completion Date <span class="text-danger">*</span></h6>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <input type="hidden" id="id" name="id">
                    <input type="hidden" id="status" name="status">
                    <div class="form-group">
                        <input type="date" class="form-control form-control-sm" id="completed_date" name="completed_date">
                    </div>

                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger btn-sm" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary btn-sm submitBtn">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal end -->

@endif


@endsection

@section('scripts')


<script>

    $('.student_class').on('change', function(){
        let student_class_id = $('.student_class').val();
        getSection(student_class_id);
        getSubjects(student_class_id);
    });

    $('.subject_id').on('change', function(){
        let student_class_id = $('.student_class').val();
        let subject_id = $('.subject_id').val();
        let section_id = $('.section_id').val();
        console.log('student_class_id '+ student_class_id + ' subject_id '+ subject_id+ ' section_id '+ section_id);
        getLessons(student_class_id,subject_id,section_id);
    });


    

    let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
    let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";
    let section_id = "{{ isset($section_id) ? $section_id : '' }}";

    if(student_class_id!=''){
        getSection(student_class_id);
        getSubjects(student_class_id);
    }

    if(student_class_id!='' && subject_id!=''){
        getLessons(student_class_id,subject_id,section_id);
    }

    

    function getSection(student_class_id){

        let section_id = "{{ isset($section_id) ? $section_id : '' }}";
        if(student_class_id){
            $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let sections = response;
                let option = '<option value="">--Select Section--</option>';
                for(let i=0;i<sections.length;i++){
                    // if(sections[i].student_class_id == student_class_id){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }

                    // }
                }
                console.log(option);
                $('select.section_id').empty().append(option);
            });
        }
    }

    //------------------Get Class Wise Subject List----------------

    function getSubjects(student_class_id){
        
        if(student_class_id){
            $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let subjects = response;

                let option = '<option value="">All Subject</option>';
                for(let i=0;i<subjects.length;i++){
                    if(subjects[i].student_class_id == student_class_id){
                        if(subject_id==subjects[i].subject_id){
                            option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                        }else{
                            option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                        }

                    }
                }
                $('select.subject_id').empty().append(option);
            });
        }
    }

    //------------------Get lesson list----------------

    function getLessons(student_class_id,subject_id,section_id){
        if(student_class_id){
            $.get('{{ route('lesson.list_by_class') }}', { student_class_id: student_class_id, subject_id: subject_id, section_id: section_id }, function(response) {
                let lessons = response;
                console.log(lessons);
                let option = '<option value="">--Select Lesson--</option>';
                for(let i=0;i<lessons.length;i++){
                    console.log(lessons[i].id)

                    if(lesson_id==lessons[i].id){
                        option += '<option value='+lessons[i].id+' selected>'+lessons[i].name+'</option>';
                    }else{
                        option += '<option value='+lessons[i].id+' >'+lessons[i].name+'</option>';
                    }
                }
                $('select.lesson_id').empty().append(option);
            });
        }
    }

    //modal     
    $('#dataEditModal').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var status = button.data('status')
        console.log(id);
        console.log(status);
        var modal = $(this)
        modal.find('#id').val(id)
        modal.find('#status').val(status)
    })
    $('#dataEditModal').on('hidden.bs.modal', function () {
        location.reload();
    })

    //selected todays date
    document.getElementById('completed_date').value = new Date().toISOString().substring(0, 10);

            </script>
@endsection
