@extends('layouts.master')
@section('styles')
<style>
	.lesson_input{
		width: 88%;
    	display: inline-block;
	}
</style>
@endsection
@section('content')
	<div class="row">
		<div class="col-md-4">
			<div class="card mt-4">
				<div class="card-header border-bottom py-3 d-flex flex-row align-items-center justify-content-between">
			        <h6 class="m-0 table__top__txt">Add Topic</h6>
			    </div>
	            <div class="card-body">
		            <form action="{{ route('lesson_topic.store') }}" method="POST" enctype="multipart/form-data">
		                @csrf
	                    <div class="form-group">
                            <label for="student_class_id">Student Class <span class="text-danger">*</span></label>
	                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class_id" required', $student_class_id, "Class") }}
	                        @error('student_class_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
	                    </div>

	                    <div class="form-group">
                            <label for="subject_id">Subject <span class="text-danger">*</span></label>
	                        {{ generateDropdown('', 'class="form-control subject_id" id="subject_id" name="subject_id" required', $subject_id, "Sublect") }}
	                        @error('subject_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
	                    </div>


	                    <div class="form-group">
                            <label for="lesson_id">Lesson <span class="text-danger">*</span></label>
	                        {{ generateDropdown('', 'class="form-control lesson_id" id="lesson_id" name="lesson_id" required', $lesson_id, "Lesson") }}
	                        @error('lesson_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
	                    </div>

                        <div class="form-group">
                            <label for="name">Topic Name <span class="text-danger">*</span></label>
                            <br>
                            <input type="text" name="name[]" class="form-control lesson_input" required> 
                            <span id="plusBtn" title="Add More" class="text-success cursor-pointer"><i class="fas fa-plus-square"></i></span>
                        </div> 
                        <div id="append-content"></div>

                        	@error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
		                
		                <div class="row mt-3 flex justify-content-end">
		                    <button type="submit" class="btn btn-primary">Submit</button>
		                </div>

		            </form>
		        </div>
			</div>
		</div>
		<div class="col-md-8">
			<div class="card mt-4">
				<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
			        <h6 class="m-0 table__top__txt">Topic List</h6>
			    </div>
	            <div class="table-responsive" >
	                <table class="table">
	                    <thead class="thead-light">
	                        <tr>
	                            <th>Class</th>
	                            <th>Subject</th>
	                            <th>Lesson</th>
	                            <th>Topic</th>
	                            <th class="action__col">Action</th>
	                        </tr>
	                    </thead>
	                    <tbody>
	                        @if($topics->isNotEmpty())
	                        @foreach($topics as $topic)
	                        <tr>
	                        	<td>{{ $topic->studentClass->class_name }}</td>
	                        	<td>{{ $topic->subject->subject_name }}</td>
	                        	<td>{{ $topic->lesson->name }}</td>
	                        	@php $groups =  group_lesson_topics($topic->student_class_id,$topic->subject_id,$topic->lesson_id);  @endphp
	                        	<td>
	                        		@foreach($groups as $item)
	                        		{{ $item->name }} <br>
	                        		@endforeach

	                        	</td>
	                        	<td>
	                        		<a href="{{ route('lesson_topic.edit', $topic->id) }}" class="btn btn-sm btn-soft-info mx-1"><i class="fas fa-edit"></i></a>
	                                <form action="{{ route('lesson_topic.destroy', $topic->id) }}" method="POST" style="display: inline;">
	                                    @csrf
	                                    @method('DELETE')
	                                    <button type="submit" class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this building floor?')"><i class="fas fa-trash"></i></button>
	                                </form>
	                        	</td>
	                        </tr>
	                        @endforeach
	                        @else
	                        <tr><td colspan="6" class="text-center">No data available in table</td></tr>
	                        @endif
	                    </tbody>
	                </table>
	            </div>
			</div>

		</div>
	</div>
    

@stop
@section('scripts')
<script>
    $(document).ready(function () {
        $("#plusBtn").click(function (ele) {
            ele.preventDefault();
            $("#append-content").append('<div class="container_label"><div class="form-group"><label for="name">Topic Name <span class="text-danger">*</span></label><br><input type="text" name="name[]" class="form-control lesson_input" required> <span class="text-danger cursor-pointer removeBtn" title="Remove This"><i class="fas fa-minus-square"></i></span></div></div>')
        })

        $(document).on('click', '.removeBtn', function () {
            $(this).closest('.container_label').remove();
        });
    });


    	$('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
            getSubjects(student_class_id);
        });

        $('.subject_id').on('change', function(){
            let student_class_id = $('.student_class').val();
            let subject_id = $('.subject_id').val();
            let section_id = $('.section_id').val();
            getLessons(student_class_id,subject_id,section_id);
        });


        

        let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
        let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";
        let section_id = "{{ isset($section_id) ? $section_id : '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
            getSubjects(student_class_id);
        }

        if(student_class_id!='' && subject_id!=''){
            getLessons(student_class_id,subject_id,section_id);
        }

        

        function getSection(student_class_id){

            let section_id = "{{ isset($section_id) ? $section_id : '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }

    	//------------------Get Class Wise Subject List----------------

        function getSubjects(student_class_id){
            
            if(student_class_id){
                $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let subjects = response;

                    let option = '<option value="">--Select Subject--</option>';
                    for(let i=0;i<subjects.length;i++){
                        if(subjects[i].student_class_id == student_class_id){
                            if(subject_id==subjects[i].subject_id){
                                option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                            }else{
                                option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                            }

                        }
                    }
                    $('select.subject_id').empty().append(option);
                });
            }
        }

        //------------------Get lesson list----------------

        function getLessons(student_class_id,subject_id,section_id){
            if(student_class_id){
                $.get('{{ route('lesson.list_by_class') }}', { student_class_id: student_class_id, subject_id: subject_id, section_id: section_id }, function(response) {
                    let lessons = response;
                    let option = '<option value="">--Select Lesson--</option>';
                    for(let i=0;i<lessons.length;i++){

                    	if(lesson_id==lessons[i].id){
                            option += '<option value='+lessons[i].id+' selected>'+lessons[i].name+'</option>';
                        }else{
                            option += '<option value='+lessons[i].id+' >'+lessons[i].name+'</option>';
                        }
                    }
                    $('select.lesson_id').empty().append(option);
                });
            }
        }
</script>
@endsection
