@extends('layouts.master')
@section('content')



    <div class="row">
        <div class="col-xl-12 col-xxl-8 m-auto">
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Transfer Certificate List</h6>
                    <div class="m-0 float-right">
                        @can('academic.branches.create')
                            <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                    data-toggle="modal" data-target="#dataStoreModal">Add New
                            </button>
                        @endcan
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Student</th>
                                    <th>reason</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if($certificates->isNotEmpty())
                                    @foreach ($certificates as $certificate)
                                        <tr>
                                            <td>{{ $certificate->id }}</td>
                                            <td>{{ $certificate->student_info_id }}</td>
                                            <td>{{ $certificate->reason }}</td>
                                            <td class="">
                                                @can('academic.branches.edit')
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#dataEditModal"
                                                            data-reason="{{ $certificate->reason }}"
                                                            data-student_info_id="{{ $certificate->student_info_id }}"
                                                            data-id="{{ $certificate->id }}"><i class="fas fa-edit"></i>
                                                    </button>
                                                @endcan
                                                @can('academic.branches.delete')
                                                    <form action="{{ route('tc.destroy', $certificate->id) }}"
                                                          method="POST"
                                                          class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure you want to delete this certificate?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6" class="text-center">No data available in table</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('tc.store') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Transfer Certificate </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="student_info_id">Student <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="student_info_id" name="student_info_id" required>
                                <option value='1'>Active</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="reason">Reason <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="reason" name="reason" placeholder="Enter Reason" required  rows="10"></textarea>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="{{ route('tc.update') }}">
                @csrf
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Transfer Certificate </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="student_info_id">Student <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="student_info_id" name="student_info_id" required>
                                <option value='1'>Active</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="reason">Reason <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="reason" name="reason" placeholder="Enter Reason" required  rows="10"></textarea>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- modal end -->
@stop
@section('scripts')
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var student_info_id = button.data('student_info_id')
            var reason = button.data('reason')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#student_info_id').val(student_info_id)
            modal.find('#reason').val(reason)
            modal.find('#id').val(id)
        })
    </script>
@endsection
