@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body card__head">

            <!-- Nav tabs -->
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a class="nav-link {{ request()->query('tab', 'search') === 'search' ? 'active' : '' }}" data-toggle="tab" href="#search-tab">Search By ID</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->query('tab') === 'filter' ? 'active' : '' }}" data-toggle="tab" href="#filter-tab">Search by Class</a>
                </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
                <div id="search-tab" class="tab-pane {{ request()->query('tab', 'search') === 'search' ? 'show active' : '' }}"><br>
                    <form method="GET" action="{{ route('assign-stoppage.index') }}" class="row">
                        <input type="hidden" name="tab" value="search">
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            @component('components.search_student', [
                                'student_name' => request()->query('student_name') ?? '',
                                'student_id_no' => request()->query('student_id_no') ?? '',
                                'required' => '',
                            ])
                            @endcomponent
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
                <div id="filter-tab" class="tab-pane fade {{ request()->query('tab') === 'filter' ? 'show active' : '' }}"><br>
                    <form method="GET" action="{{ route('assign-stoppage.index') }}" class="row">
                        <input type="hidden" name="tab" value="filter">
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class" required', request()->query('student_class'), "Class") }}
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                        </div>
                        <div class="form-group col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Student List</h6>
        <div class="m-0 float-right">
            
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                            <tr>
                                <th>Roll</th>
                                <th>Stu. ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Stoppage</th>
                                <th>Amount</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($students)
                                @foreach ($students as $student)
                                    <tr>
                                        <td>{{ $student->class_roll ?? "" }}</td>
                                        <td> <a href="{{route('student_info.edit', $student->id)}}" target="_blank">{{ $student->student_id_no }}</a> </td>
                                        <td>{{ $student->first_name." ".$student->last_name }}</td>
                                        <td>{{ $student->studentClass?->class_name ?? "" }}</td>
                                        <td>
                                            {{ generateDropdown($stoppages, 'class="form-control stoppage_id"', $student->studentTransport?->stoppage_id, 'Stoppage') }}
                                            <input type="hidden" class="student_id" value="{{ $student->id }}">
                                        </td>
                                        <td>
                                            <input type="number" class="monthly_cost" min="0" max="20000" value="{{ (int) ($student->studentTransport?->monthly_cost ?? 0) }}">
                                        </td>
                                        <td class="d-flex justify-content-between">
                                            <button class="btn btn-sm {{ $student->studentTransport?->student_id ? 'btn-success' : 'btn-info' }} " onclick="saveData(this)">{{ $student->studentTransport?->student_id ? 'Update' : 'Save' }}</button>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="9" class="text-center">No data available in table</td>
                                </tr>    
                            @endif
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

    <!-- Modal -->
    {{-- <div class="modal fade" id="assignModal" tabindex="-1" aria-labelledby="assignModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="assignModalLabel">Assign Routes Stoppage</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="code">Routes</label>
                        {{ generateDropdown($transport_routes, 'class="form-control select2 route_id" id="route_id" name="route_id" required', '', "Select Route") }}
                    </div>
                    <div class="form-group">
                        <label for="code">Stoppage</label>
                        {{ generateDropdown([], 'class="form-control select2 stoppage_id" id="stoppage_id" name="stoppage_id" required', '', "Select Stopage") }}
                    </div>

                    <div class="modalContent">
                        <input type="hidden" name="student_id" id="student_id" class="student_id">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="saveData()">Save</button>
                </div>
            </div>
        </div>
    </div> --}}

@endsection
@section('scripts')
    <script>

        // $('.student_class').on('change', function(){
        //     let student_class_id = $('.student_class').val();
        //     getSection(student_class_id);
        // });

        // let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        // if(student_class_id!=''){
        //     getSection(student_class_id);
        // }

        // function getSection(student_class_id){

        //     let section_id = "{{ request()->query('section') ?? '' }}";
        //     if(student_class_id){
        //         $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
        //             let sections = response;
        //             console.log(sections);
        //             let option = '<option value="">Section</option>';
        //             for(let i=0;i<sections.length;i++){

        //                 if(section_id==sections[i].id){
        //                     option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
        //                 }else{
        //                     option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
        //                 }

        //             }
        //             $('select.section').empty().append(option);
        //         });
        //     }
        // }

        // $('#assignModal').on('show.bs.modal', function(event) {
        //     $('#hostel-room-search').focus();
        //     var button = $(event.relatedTarget);
        //     var action = button.data('action');
        //     var studentId = button.data('student_id');
        //     $('#student_id').val(studentId);

        //     var modal = $(this);

        //     if(action=='edit'){
        //         var hostel_room = button.data('student_transport_details');
        //         let route_id = hostel_room.route_id
        //         let stoppage_id = hostel_room.stoppage_id

        //         modal.find('#route_id').val(route_id).trigger('change');
        //         modal.find('#stoppage_id').val(stoppage_id).trigger('change');

        //         $('#student_id').val(studentId);
        //         getStoppage(route_id, stoppage_id);
        //     }
        // });

        // $('#assignModal').on('hidden.bs.modal', function() {
        //     $('#route_id').val('').trigger('change');
        //     $('#stoppage_id').val('').trigger('change');
        // });

        // $('.route_id').on('change', function(){
        //     let route_id = $(this).val();
        //     let stoppage_id = '';
        //     getStoppage(route_id, stoppage_id);
        // });

        // function getStoppage(route_id, stoppage_id){

        //     if(route_id){
        //         $.get('{{ route('stoppage-list-by-route') }}', { route_id: route_id }, function(response) {
        //             let stoppages = response;

        //             let option = '<option value="">--Select Stopages--</option>';
        //             for(let i=0;i<stoppages.length;i++){

        //                 if(stoppage_id==stoppages[i].id){
        //                     option += '<option value='+stoppages[i].id+' selected>'+stoppages[i].name+ ' -> ( Tk. '+stoppages[i].monthly_cost+')</option>';
        //                 }else{
        //                     option += '<option value='+stoppages[i].id+' >'+stoppages[i].name+ ' -> ( Tk. '+stoppages[i].monthly_cost+')</option>';
        //                 }

        //             }
        //             $('select.stoppage_id').empty().append(option);
        //         });
        //     }
        // }


        function saveData(btn) {
            let row = $(btn).closest('tr');

            let student_id  = row.find('.student_id').val();
            let stoppage_id = row.find('.stoppage_id').val();
            let monthly_cost      = row.find('.monthly_cost').val();
            console.log(monthly_cost)
            const csrfToken = document.head.querySelector(
                'meta[name="csrf-token"]'
            ).content;

            $.ajax({
                url: "{{ route('assign-stoppage.store') }}",
                type: "POST",
                data: {
                    _token: csrfToken,
                    student_id: student_id,
                    stoppage_id: stoppage_id,
                    monthly_cost: monthly_cost
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                        $(btn).text('Update').removeClass('btn-info').addClass('btn-success');
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Something went wrong');
                }
            });
        }
    </script>
@endsection
