@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Create Routes</h6>
        <div class="m-0 float-right">
            <a href="{{ route('transport-route.index') }}" class="btn btn-sm btn-primary">View All</a>
        </div>
    </div>

    <div class="card-body">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <form action="{{route('transport-route.store')}}" method="post">
                    @csrf
                    <input type="hidden" name="_method" id="formMethod">
                    <div class="form-group">
                        <label for="route_name">Route Name <span class="text-danger">*</span></label>
                        <input type="text" name="route_name" id="route_name" class="form-control" required placeholder="Enter route name">
                    </div>

                    <div class="form-group">
                        <label for="start_point">Start Point <span class="text-danger">*</span></label>
                        <input type="text" name="start_point" id="start_point" class="form-control" required placeholder="Enter start point">
                    </div>

                    <div class="form-group">
                        <label for="end_point">End Point <span class="text-danger">*</span></label>
                        <input type="text" name="end_point" id="end_point" class="form-control" required placeholder="Enter end point">
                    </div>

                    <div class="form-group">
                        <label for="vehicle_no">Vehicle No <span class="text-danger">*</span></label>
                        {{-- <input type="text" name="vehicle_no" id="vehicle_no" class="form-control" required placeholder="Enter Vehicle No"> --}}
                        {{ generateDropdown($vehicles, 'class="form-control select2 vehicle" id="vehicle" name="vehicle_id" required', '', "Select Vehicle") }}
                    </div>

                    <div class="form-group">
                        <label for="driver_id">Driver ID <span class="text-danger">*</span></label>
                        <input type="number" min="0" name="driver_id" id="driver_id" class="form-control" placeholder="Driver ID" required>
                    </div>

                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="departure_time">Departure Time <span class="text-danger">*</span></label>
                                <input type="time" name="departure_time" id="departure_time" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label for="arrival_time">Arrival Time <span class="text-danger">*</span></label>
                                <input type="time" name="arrival_time" id="arrival_time" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group float-right">
                        <a href="{{ route('transport-route.index') }}" class="btn btn-secondary ml-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Create</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
