@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Routes</h6>
        <div class="m-0 float-right">
            <a href="{{ route('transport-route.create') }}" class="btn btn-sm btn-primary">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>SN</th>
                            <th>Route Name</th>
                            <th>Start Point</th>
                            <th>End Point</th>
                            <th>Vehicle</th>
                            <th>Driver ID</th>
                            <th>Departure Time</th>
                            <th>Arrival Time</th>
                            <th class="action__col">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @if($routes->isNotEmpty())
                        @php
                            $sn = 0;
                        @endphp
                        @foreach ($routes as $route)
                            <tr>
                                <td>{{ ++$sn }}</td>
                                <td>{{ $route->route_name }}</td>
                                <td>{{ $route->start_point }}</td>
                                <td>{{ $route->end_point }}</td>
                                <td>{{ $route->vehicle->vehicle_number }}</td>
                                <td>{{ $route->driver_id }}</td>
                                <td>{{ time_in_am_pm($route->departure_time) }}</td>
                                <td>{{ time_in_am_pm($route->arrival_time) }}</td>
                                <td class="d-flex justify-content-start">
                                    <a class="btn btn-sm btn-soft-info" href="{{route('transport-route.edit', $route->id)}}"><i class="fas fa-edit"></i></a>
                                    <form action="{{ route('transport-route.destroy', $route->id) }}" method="POST"
                                        style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        @else
                        <tr><td colspan="10" class="text-center">No data available in table</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {

    });
</script>
@endsection
