@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Stoppage list</h6>
                <div class="m-0 float-right">
                    <button class="btn btn-sm btn-light-blue" id="add-student-btn" data-toggle="modal" data-target="#stoppageModal">Add
                    New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($stoppages->isNotEmpty())
                                @php
                                    $sn = 1
                                @endphp
                                @foreach ($stoppages as $stoppage)
                                    <tr>
                                        <td>{{ $sn++; }}</td>
                                        <td>{{ $stoppage->name }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button type="button" class="btn btn-sm btn-soft-info mr-1" data-toggle="modal" data-target="#stoppageModal"
                                                data-action="edit"
                                                data-id="{{ $stoppage->id }}"
                                                data-name="{{ $stoppage->name }}">
                                                <i class="fas fa-edit"></i>
                                            </button>

                                            <form action="{{ route('stoppage.destroy', $stoppage->id) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @else
                                <tr><td colspan="8" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="stoppageModal" tabindex="-1" role="dialog" aria-labelledby="stoppageModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="stoppageModalLabel">Create/Edit Stoppage</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="stoppageForm" method="POST">
                    @csrf
                    @method('POST')
                    <input type="hidden" id="id" name="id" value="">
                    <div class="form-group">
                        <label for="name">Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" class="form-control" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                <button type="submit" class="btn btn-submit" form="stoppageForm">Submit</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $('#stoppageModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var action = button.data('action');
            var id = button.data('id');

            var modal = $(this);
            var form = modal.find('form');
            var method = id ? 'PUT' : 'POST';
            modal.find('[name="_method"]').val(method);

            if (action === 'edit') {
                form.attr('action', '/stoppage/update/' + id);
                modal.find('.modal-title').text('Edit Stoppage');
                modal.find('#name').val(button.data('name'));
                modal.find('#route_id').val(button.data('route_id')).trigger('change');
                modal.find('#pickup_time').val(button.data('pickup_time'));
                modal.find('#drop_time').val(button.data('drop_time'));
                modal.find('#monthly_cost').val(Math.floor(button.data('monthly_cost')));
            } else {
                form.attr('action', '{{ route("stoppage.store") }}');
                modal.find('.modal-title').text('Create New Stoppage');
                modal.find('#name').val('');
                modal.find('#route_id').val('').trigger('change');
                modal.find('#pickup_time').val('');
                modal.find('#drop_time').val('');
                modal.find('#monthly_cost').val('');
            }
        });
    });
</script>
@endsection
